/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Wuerfelreihe;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Turnier;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Wechselfeld
extends JPanel
implements ChangeListener {
    private static final int WUERFELRAHMENABSTAND = 4;
    private static final String VERSTECK = "Versteck";
    private static final String ANZEIGE = "Anzeige";

    Wechselfeld(Wuerfelreihe reihe) {
        super(new CardLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "W\u00fcrfelauswahl", 2, 2), BorderFactory.createEmptyBorder(0, 2, 4, 2)));
        this.add((Component)new JPanel(), VERSTECK);
        this.add((Component)reihe, ANZEIGE);
        this.setToolTipText("Sortieren durch Doppelklick auf freie Fl\u00e4che, Kontextmen\u00fc");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: 
                case SPIEL: 
                case GEWUERFELT: 
                case GESETZT: 
                case RUECKGAENGIG: {
                    this.aktualisiere((Turnier)ce.getSource());
                    break;
                }
                case RESULTAT: {
                    this.verstecke();
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.setEnabled(false);
                    break;
                }
            }
        }
    }

    private void aktualisiere(Turnier turnier) {
        boolean neu = turnier.aktiver().neu();
        boolean interaktiv = turnier.aktiver().interaktiv();
        this.setEnabled(!neu && interaktiv);
        ((CardLayout)this.getLayout()).show(this, neu ? VERSTECK : ANZEIGE);
    }

    private void verstecke() {
        ((CardLayout)this.getLayout()).show(this, VERSTECK);
    }
}

