/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Becher;
import jafuffy.bedienung.Setzen;
import jafuffy.bedienung.Verfolgung;
import jafuffy.bedienung.Vorschlagen;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import jafuffy.logik.Wuerfel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Aufsicht
implements ChangeListener {
    private static final int AKTIONSDAUER_DEUTLICH = 1200;
    private static final int AKTIONSDAUER_SCHNELL = 400;
    public static final String ANSTEHENDE_AKTION = "Anstehende Aktion";
    public static final String ALLE_AKTIONEN = "Alle Aktionen";
    private final Action alleAktionen = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Aufsicht.this.schritt.mache(event);
            Aufsicht.this.automatisiert = true;
            Aufsicht.this.weiter();
        }
    };
    private final Action naechsteAktion = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Aufsicht.this.schritt.mache(event);
        }
    };
    private final Eigenschaften eigenschaften;
    private final Becher becher;
    private final Vorschlagen vorschlagen;
    private final Setzen setzen;
    private final Verfolgung verfolgung;
    private final Ueberlegungsaktion ueberlegungsaktion = new Ueberlegungsaktion();
    private final Wurfaktion wurfaktion = new Wurfaktion();
    private final Setzaktion setzaktion = new Setzaktion();
    private final Pausenaktion pausenaktion = new Pausenaktion();
    private Turnier turnier;
    private Spieler aktiver;
    private Schritt schritt;
    private boolean automatisiert;

    Aufsicht(Eigenschaften eigenschaften, Vorschlagen vorschlagen, Becher becher, Verfolgung verfolgung, Setzen setzen) {
        this.eigenschaften = eigenschaften;
        this.becher = becher;
        this.vorschlagen = vorschlagen;
        this.setzen = setzen;
        this.verfolgung = verfolgung;
        verfolgung.verknuepfe(this.alleAktionen, ALLE_AKTIONEN, "<html>Bot soll alle seine anstehenden Aktionen abschlie\u00dfen und dann die W\u00fcrfel abgeben.<br><small>Mausklick oder Taste \"Ende\"</small></html>");
        verfolgung.verknuepfe(this.naechsteAktion, ANSTEHENDE_AKTION, "<html>Bot soll nur mit seiner n\u00e4chsten anstehenden Aktion weitermachen.<br><small>Mausklick oder Taste \"Bild ab\"</small></html>");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            this.turnier = (Turnier)cej.quelle(Turnier.class);
            this.aktiver = this.turnier.aktiver();
            if (this.aktiver.interaktiv()) {
                return;
            }
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: 
                case SPIEL: {
                    if (this.wuerfelbereit()) {
                        this.installiere(this.wurfaktion);
                    } else {
                        this.installiere(this.ueberlegungsaktion);
                    }
                    this.aktiviere(true);
                    break;
                }
                case RESULTAT: 
                case ENDE: {
                    this.installiere(this.pausenaktion);
                    this.aktiviere(false);
                    break;
                }
                case GESETZT: {
                    this.installiere(this.wurfaktion);
                    this.aktiviere(true);
                    break;
                }
                case GEWUERFELT: {
                    this.installiere(this.ueberlegungsaktion);
                    break;
                }
            }
        }
    }

    private int aktionsdauer() {
        if (this.eigenschaften.aktiv("Aktionsdarstellungsbeschleunigung")) {
            return 400;
        }
        return 1200;
    }

    private void aktiviere(boolean aktiv) {
        this.naechsteAktion.setEnabled(aktiv);
        this.alleAktionen.setEnabled(aktiv);
    }

    private void installiere(Schritt schritt) {
        this.schritt = schritt;
        this.naechsteAktion.putValue("LongDescription", this.aktiver + schritt.toString());
    }

    private void weiter() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Aufsicht.this.verfolgung.erledigeNaechsteAktion(Aufsicht.this.aktionsdauer());
            }
        });
    }

    private boolean wuerfelbereit() {
        if (this.aktiver.neu()) {
            return true;
        }
        Wuerfel[] wuerfelArray = this.turnier.wuerfelsatz();
        int n = wuerfelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel wuerfel = wuerfelArray[n2];
            if (wuerfel.darstellungsmodell().isSelected()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class Pausenaktion
    implements Schritt {
        private Pausenaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
        }

        public String toString() {
            return " hat keine weitere Aktion vor.";
        }
    }

    private static interface Schritt {
        public void mache(ActionEvent var1);
    }

    private class Setzaktion
    implements Schritt {
        private Setzaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.setzen.doClick();
            Aufsicht.this.automatisiert = false;
            Aufsicht.this.alleAktionen.setEnabled(true);
        }

        public String toString() {
            return " m\u00f6chte jetzt setzen.";
        }
    }

    private class Ueberlegungsaktion
    implements Schritt {
        private Ueberlegungsaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.alleAktionen.setEnabled(false);
            Aufsicht.this.vorschlagen.doClick();
            if (Aufsicht.this.automatisiert || Aufsicht.this.eigenschaften.aktiv("Ueberlegungsdarstellungsbeschleunigung")) {
                Aufsicht.this.weiter();
            }
            if (Aufsicht.this.wuerfelbereit()) {
                Aufsicht.this.installiere(Aufsicht.this.wurfaktion);
            } else {
                Aufsicht.this.installiere(Aufsicht.this.setzaktion);
            }
        }

        public String toString() {
            if (Aufsicht.this.eigenschaften.aktiv("Ueberlegungsdarstellungsbeschleunigung")) {
                return " m\u00f6chte jetzt w\u00fcrfeln oder setzen.";
            }
            return " m\u00f6chte jetzt \u00fcberlegen.";
        }
    }

    private class Wurfaktion
    implements Schritt {
        private Wurfaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.alleAktionen.setEnabled(false);
            Aufsicht.this.becher.doClick();
            if (Aufsicht.this.automatisiert) {
                Aufsicht.this.weiter();
            }
        }

        public String toString() {
            return " m\u00f6chte jetzt w\u00fcrfeln.";
        }
    }
}

