/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Aenderungen;
import jafuffy.logik.CEWuerfel;
import java.io.Serializable;
import java.util.Random;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;

public class Wuerfel
implements Comparable<Wuerfel>,
Serializable {
    private static final long serialVersionUID = 6889772262239748227L;
    public static final int MAXIMALAUGENAUGENZAHL = 6;
    private static final Random ZUFALL = new Random();
    private transient Aenderungen<CEWuerfel> aenderungen;
    private transient ButtonModel darstellungsmodell;
    private int augen;
    private boolean vorgeschlagen;

    Wuerfel(int augen) {
        this.augen = augen;
    }

    public int augen() {
        return this.augen;
    }

    @Override
    public int compareTo(Wuerfel wuerfel) {
        return Integer.compare(this.augen(), wuerfel.augen());
    }

    public ButtonModel darstellungsmodell() {
        if (this.darstellungsmodell == null) {
            this.darstellungsmodell = new JToggleButton.ToggleButtonModel(){

                @Override
                public void setSelected(boolean selektiert) {
                    boolean feuern = this.isSelected() ^ selektiert;
                    super.setSelected(selektiert);
                    if (feuern) {
                        Wuerfel.this.aenderungen.fireStateChanged(selektiert ? CEWuerfel.ANWAHL : CEWuerfel.ABWAHL);
                    }
                }
            };
        }
        return this.darstellungsmodell;
    }

    public void entferneChangeListener(ChangeListener changeListener) {
        this.aenderungen.removeChangeListener(changeListener);
    }

    public void installiereChangeListener(ChangeListener changeListener) {
        if (this.aenderungen == null) {
            this.aenderungen = new Aenderungen();
        }
        this.aenderungen.addChangeListener(changeListener);
    }

    public void setzeVorschlag(boolean vorschlagen) {
        this.vorgeschlagen = vorschlagen;
    }

    public boolean vorgeschlagen() {
        return this.vorgeschlagen;
    }

    public int vorkommen(int[] haeufigkeiten) {
        return haeufigkeiten[this.augen - 1];
    }

    void wirf() {
        this.vorgeschlagen = false;
        this.augen = ZUFALL.nextInt(6) + 1;
        this.aenderungen.fireStateChanged(CEWuerfel.WURF);
        this.darstellungsmodell.setSelected(false);
    }
}

