/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.auswertung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.auswahl.Auswahl;
import jafuffy.logik.Kategorie;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.auswertung.Klassisch;

public class Erweitert
extends Klassisch {
    private static final long serialVersionUID = 81708878516443751L;
    public static final Class<? extends Auswahl> AUSWAHLKLASSE = jafuffy.bedienung.auswahl.Erweitert.class;
    public static final String REGEL = "Erweiterte Regeln";
    private static final int ABWEICHUNG = 60;
    private static final int MITTELWERT = 240;
    private boolean istBonusnachrichtAngefordert = false;
    private boolean istJokerNachrichtAngefordert = false;
    private boolean istSetzzwangNachrichtAngefordert = false;

    public Erweitert(Wuerfel[] wuerfel) {
        super(wuerfel, new jafuffy.logik.analyse.Erweitert(wuerfel));
    }

    @Override
    public int abweichung() {
        return 60;
    }

    @Override
    public int mittelwert() {
        return 240;
    }

    @Override
    public String spicker(Kategorie kategorie) {
        if (Eigenschaften.GLOBAL.aktiv("Spicker") && this.aktiver.gewuerfelt() && ((jafuffy.logik.analyse.Erweitert)this.analyse).istJokerVorliegend(this.aktiver) && kategorie == Kategorie.JAFUFFY) {
            String text = "<p align=center><em>Joker (+ 100 Bonuspunkte)!</em></p><p>Bitte Wurf in freies Feld eintragen.</p>";
            if (this.sindTippsAngefordert()) {
                return "<html>" + text + "<p>Kontextmen\u00fc!</p></html>";
            }
            return "<html>" + text + "</html>";
        }
        return super.spicker(kategorie);
    }

    @Override
    public String text(Kategorie kategorie) {
        if (kategorie == Kategorie.JAFUFFY && this.istJokerNachrichtAngefordert) {
            return "Joker!";
        }
        if (kategorie == Kategorie.JAFUFFY && this.istBonusnachrichtAngefordert) {
            return "Bonus!";
        }
        if (this.istSetzzwangNachrichtAngefordert && kategorie == Kategorie.oben(this.wuerfelsatz[0].augen())) {
            return "Gesetzt!";
        }
        return null;
    }

    @Override
    public String toString() {
        return REGEL;
    }

    public void zeigeBonusnachricht(boolean istBonusErzielt) {
        this.istBonusnachrichtAngefordert = istBonusErzielt;
    }

    public void zeigeJokernachricht(boolean istJokerVerfuegbar) {
        if (istJokerVerfuegbar) {
            Wuerfel[] wuerfelArray = this.wuerfelsatz;
            int n = this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                w.darstellungsmodell().setEnabled(false);
                ++n2;
            }
        }
        this.istJokerNachrichtAngefordert = istJokerVerfuegbar;
    }

    public void zeigeSetzzwangnachricht(boolean istSetzzwangGegeben) {
        if (istSetzzwangGegeben) {
            Wuerfel[] wuerfelArray = this.wuerfelsatz;
            int n = this.wuerfelsatz.length;
            int n2 = 0;
            while (n2 < n) {
                Wuerfel w = wuerfelArray[n2];
                w.darstellungsmodell().setEnabled(false);
                ++n2;
            }
        }
        this.istSetzzwangNachrichtAngefordert = istSetzzwangGegeben;
    }
}

