/******************************************************************************
 ** $Id: Eroeffnung.java 1610 2018-12-16 16:26:12Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Random;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.WindowConstants;

import jafuffy.logik.Spieler;

/**
 * Bestimmt, welcher Spieler das Turnier erffnet. Die Auswahl erfolgt durch den Anwender oder durch Auswrfeln seitens
 * des Computer.
 */
@SuppressWarnings("serial")
class Eroeffnung extends JDialog {

    /** Abstand vom Dialograhmen zum Inhalt. */
    private static final int DIALOGRAHMENABSTAND = 8;
    /** Abstand Feldrahmen zu Buttons. */
    private static final int BUTTONABSTAND = DIALOGRAHMENABSTAND / 2;
    /** Bentigt zum Bestimmen einer Zufallszahl. */
    private static final Random ZUFALL = new Random();
    /** Spieler, welcher das Turnier erffnet. */
    private Spieler erster = null;

    /**
     * Erzeugt den Dialog zur Festlegung der Turniererffnung.
     *
     * @param teilnehmer
     *            Alle teilnehmenden Spieler im Turnier.
     */
    Eroeffnung(ArrayList<Spieler> teilnehmer) {
        setTitle("JaFuffy (Wer wrfelt zuerst?)");
        setIconImages(Oberflaeche.LOGOS);
        JButton auswuerfeln = zufallsfestlegung(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                erster = teilnehmer.get(ZUFALL.nextInt(teilnehmer.size()));
            }
        });
        setContentPane(hauptfeld(auswuerfeln, anwenderfestlegung(teilnehmer)));
        getRootPane().setDefaultButton(auswuerfeln);
        pack();
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        setModal(true);
    }

    /**
     * Der Anwender bestimmt im Auswahlfeld, wer das Turnier erffnet.
     * 
     * @param teilnehmer
     *            Alle Mitspieler im Turnier.
     * @return Das Auswahlfeld mit Buttons.
     */
    private JPanel anwenderfestlegung(ArrayList<Spieler> teilnehmer) {
        JPanel auswaehlen = new JPanel(new GridLayout(0, 1, 0, BUTTONABSTAND));
        for (Spieler spieler : teilnehmer) {
            JButton button = new JButton(spieler.toString());
            button.setToolTipText(spieler + " wrfelt zuerst");
            button.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent event) {
                    setVisible(false);
                    erster = spieler;
                }
            });
            auswaehlen.add(button);
        }
        return auswaehlen;
    }

    /**
     * Der Computer bestimmt per Zufall, wer das Turnier erffnet.
     * 
     * @param reaktion
     *            Die Reaktion auf einen Button-Klick.
     * @return Button, welcher die zufllige Auswahl anstt.
     */
    private JButton zufallsfestlegung(ActionListener reaktion) {
        JButton auswuerfeln = new JButton("zufllig bestimmen");
        auswuerfeln.addActionListener(reaktion);
        auswuerfeln.setToolTipText("Computer bestimmt, wer zuerst wrfelt");
        auswuerfeln.requestFocus();
        return auswuerfeln;
    }

    /**
     * Baut das Hauptfeld des Dialogs zusammen.
     * 
     * @param auswuerfeln
     *            Hiermit wird das Auswrfeln des erffnenden Spielers bestimmt.
     * @param auswaehlen
     *            Hiermit wird das Auswhlen des erffnenden Spielers durch den Anwender bestimmt.
     * @return Hauptfeld des Dialogs.
     */
    private JPanel hauptfeld(JButton auswuerfeln, JPanel auswaehlen) {
        JPanel hauptfeld = new JPanel(new BorderLayout(BUTTONABSTAND, BUTTONABSTAND));
        hauptfeld.setBorder(BorderFactory.createEmptyBorder(DIALOGRAHMENABSTAND, DIALOGRAHMENABSTAND,
                DIALOGRAHMENABSTAND, DIALOGRAHMENABSTAND));
        hauptfeld.add(auswaehlen, BorderLayout.WEST);
        hauptfeld.add(auswuerfeln, BorderLayout.CENTER);
        return hauptfeld;
    }

    /** @return Spieler, der das Turnier erffnet. */
    Spieler erster() {
        return erster;
    }

}
