/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Kategorie;
import java.io.Serializable;
import java.util.HashMap;

public class Spieler
implements Comparable<Spieler>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5170511106942700515L;
    public static final int SPIELER = 4;
    public static final int GRENZE = 63;
    public static final int BONUS = 35;
    private final String name;
    private final int index;
    private final HashMap<Kategorie, Integer> punktzahlen = new HashMap(Kategorie.ANZAHL);
    private final HashMap<Kategorie, Boolean> setzbarkeiten = new HashMap(Kategorie.ANZAHL);
    private boolean gewuerfelt;
    private boolean einmalig;
    private int rest;

    public Spieler(String name, int index) {
        this.name = name;
        this.index = index;
        this.initialisiere();
        this.beende();
    }

    public Spieler clone() {
        try {
            return (Spieler)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public int compareTo(Spieler spieler) {
        return Integer.compare(this.endsumme(), spieler.endsumme());
    }

    public boolean einmalig() {
        return this.einmalig;
    }

    public int endsumme() {
        return this.punktzahlen.get((Object)Kategorie.ESUMME);
    }

    public boolean fertig() {
        return this.rest == 0;
    }

    public int gesamt() {
        return this.punktzahlen.get((Object)Kategorie.GESAMT);
    }

    public boolean gewuerfelt() {
        return this.gewuerfelt;
    }

    public String identitaet() {
        return String.valueOf(this.name) + " (Spieler " + (this.index + 1) + ")";
    }

    public int index() {
        return this.index;
    }

    public boolean interaktiv() {
        return true;
    }

    public boolean neu() {
        return 3 == this.rest;
    }

    public double prognoseunsicherheit() {
        return 0.0;
    }

    public int punkte(Kategorie kategorie) {
        return this.punktzahlen.get((Object)kategorie);
    }

    public int rest() {
        return this.rest;
    }

    public boolean setzbar(Kategorie kategorie) {
        return this.setzbarkeiten.get((Object)kategorie);
    }

    public String toString() {
        return this.name;
    }

    private void tabelliere(Kategorie kategorie, int wert) {
        this.punktzahlen.put(kategorie, wert);
        int oben = 0;
        Kategorie[] kategorieArray = Kategorie.OBEN;
        int n = Kategorie.OBEN.length;
        int n2 = 0;
        while (n2 < n) {
            Kategorie z = kategorieArray[n2];
            oben += this.punktzahlen.get((Object)z).intValue();
            ++n2;
        }
        this.punktzahlen.put(Kategorie.GESAMT, oben);
        int bonus = 0;
        if (this.punktzahlen.get((Object)Kategorie.GESAMT) >= 63) {
            bonus = 35;
        }
        this.punktzahlen.put(Kategorie.BONUS, bonus);
        this.punktzahlen.put(Kategorie.OSUMME, oben + bonus);
        int unten = 0;
        Kategorie[] kategorieArray2 = Kategorie.UNTEN;
        int n3 = Kategorie.UNTEN.length;
        int n4 = 0;
        while (n4 < n3) {
            Kategorie z = kategorieArray2[n4];
            unten += this.punktzahlen.get((Object)z).intValue();
            ++n4;
        }
        this.punktzahlen.put(Kategorie.USUMME, unten);
        this.punktzahlen.put(Kategorie.ESUMME, oben + bonus + unten);
    }

    void aktiviere() {
        this.gewuerfelt = false;
        this.einmalig = false;
        this.rest = 3;
    }

    void annulliere(Spieler ruecknahmespieler, Kategorie ruecknahmemerker) {
        this.tabelliere(ruecknahmemerker, 0);
        this.setzbarkeiten.put(ruecknahmemerker, true);
        this.gewuerfelt = ruecknahmespieler.gewuerfelt;
        this.einmalig = ruecknahmespieler.einmalig;
        this.rest = ruecknahmespieler.rest;
    }

    void beende() {
        this.gewuerfelt = false;
        this.einmalig = false;
        this.rest = 0;
    }

    void belege(Kategorie kategorie, int wert) {
        this.tabelliere(kategorie, wert);
        this.setzbarkeiten.put(kategorie, false);
    }

    void initialisiere() {
        Kategorie[] kategorieArray = Kategorie.values();
        int n = kategorieArray.length;
        int n2 = 0;
        while (n2 < n) {
            Kategorie kategorie = kategorieArray[n2];
            this.punktzahlen.put(kategorie, 0);
            switch (kategorie) {
                case GESAMT: 
                case BONUS: 
                case OSUMME: 
                case USUMME: 
                case ESUMME: {
                    this.setzbarkeiten.put(kategorie, false);
                    break;
                }
                default: {
                    this.setzbarkeiten.put(kategorie, true);
                }
            }
            ++n2;
        }
    }

    void reagiere() {
        this.gewuerfelt = true;
        this.einmalig = this.neu();
        --this.rest;
    }
}

