/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.organisation;

import jafuffy.organisation.Anmeldung;
import jafuffy.organisation.Annahme;
import jafuffy.organisation.Kontakt;
import jafuffy.organisation.Nachricht;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;

public class Leitung
extends AbstractTableModel
implements ActionListener,
PropertyChangeListener {
    static final int PORT = 54815;
    static final String ADRESSE = "239.255.255.136";
    private final InetAddress abstimmungsgruppe;
    private final MulticastSocket abstimmungssocket;
    private final ServerSocket betriebssocket;
    private final Kontakt kontakt;
    private final ArrayList<String> teilnehmer;
    private final LinkedHashMap<String, ArrayList<String>> veranstaltungskandidaten;
    private final HashMap<String, Ueberpruefung> ueberpruefungen;
    private Chat chat;
    private Anmeldung anmeldung;
    private Annahme annahme;
    private String[] identifikationen;

    public Leitung(ArrayList<String> teilnehmer) throws UnknownHostException {
        InetAddress adresse = null;
        try {
            adresse = InetAddress.getByName(ADRESSE);
        }
        catch (UnknownHostException event) {
            event.printStackTrace();
        }
        this.abstimmungsgruppe = adresse;
        Closeable socket = null;
        try {
            socket = new MulticastSocket(54815);
            socket.joinGroup(this.abstimmungsgruppe);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.abstimmungssocket = socket;
        socket = null;
        try {
            socket = new ServerSocket(0);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.betriebssocket = socket;
        this.kontakt = new Kontakt(InetAddress.getLocalHost(), this.betriebssocket.getLocalPort());
        this.veranstaltungskandidaten = new LinkedHashMap();
        this.ueberpruefungen = new HashMap();
        this.teilnehmer = teilnehmer;
        this.veranstaltungskandidaten.put(this.kontakt.identifikation(), teilnehmer);
        this.starte();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String kommando = event.getActionCommand();
        if (kommando == "Aufnahme") {
            System.out.println(this + ": " + event);
        } else if (kommando == "Abbruch") {
            this.stoppe();
        }
    }

    public int breite(int spalte) {
        return Spalte.values()[spalte].breite;
    }

    @Override
    public int getColumnCount() {
        return Spalte.values().length;
    }

    @Override
    public String getColumnName(int spalte) {
        return Spalte.values()[spalte].toString();
    }

    @Override
    public int getRowCount() {
        return this.veranstaltungskandidaten.size();
    }

    @Override
    public Object getValueAt(int zeile, int spalte) {
        String identifikation = this.identifikationen[zeile];
        switch (Spalte.values()[spalte]) {
            case IDENTIFIKATION: {
                return this.identifikationen[zeile];
            }
            case TEILNEHMER: {
                return this.veranstaltungskandidaten.get(identifikation);
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String eigenschaft = event.getPropertyName();
        if (eigenschaft == "Senden") {
            this.anmeldung.sende(new Nachricht(this.kontakt, this.teilnehmer, event.getNewValue().toString()));
        } else if (eigenschaft == "Nachricht") {
            this.verarbeite((Nachricht)event.getNewValue());
        }
    }

    public void verfolge(Chat chat) {
        this.chat = chat;
    }

    private String[] identifikationen() {
        return this.veranstaltungskandidaten.keySet().toArray(new String[this.veranstaltungskandidaten.size()]);
    }

    private void starte() {
        this.anmeldung = new Anmeldung(this.kontakt, this.teilnehmer, this.abstimmungssocket);
        this.anmeldung.starte();
        this.annahme = new Annahme(this.abstimmungssocket);
        this.annahme.addPropertyChangeListener("Nachricht", this);
        new Thread(this.annahme).start();
    }

    private void stoppe() {
        try {
            this.abstimmungssocket.leaveGroup(this.abstimmungsgruppe);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        this.abstimmungssocket.close();
        this.annahme.removePropertyChangeListener("Nachricht", this);
    }

    private void verarbeite(Nachricht nachricht) {
        if (nachricht.text() == null) {
            String identifikation = nachricht.kontakt().identifikation();
            this.veranstaltungskandidaten.put(identifikation, nachricht.teilnehmer());
            this.identifikationen = this.identifikationen();
            if (this.ueberpruefungen.containsKey(identifikation)) {
                this.ueberpruefungen.get(identifikation).bestaetige();
            } else {
                Ueberpruefung ueberpruefung = new Ueberpruefung(identifikation);
                this.ueberpruefungen.put(identifikation, ueberpruefung);
                Ueberwachung ueberwachung = new Ueberwachung(ueberpruefung);
                ueberwachung.start();
            }
            this.fireTableDataChanged();
        } else {
            this.chat.zeige(nachricht.kontakt().identifikation(), nachricht.teilnehmer().toString(), nachricht.text());
        }
    }

    public static interface Chat {
        public void zeige(String var1, String var2, String var3);
    }

    private static enum Spalte {
        TEILNEHMER("Teilnehmer", 250),
        IDENTIFIKATION("Identifikation", 250);

        private final String titel;
        final int breite;

        private Spalte(String titel, int breite) {
            this.titel = titel;
            this.breite = breite;
        }

        public String toString() {
            return this.titel;
        }
    }

    private class Ueberpruefung
    implements ActionListener {
        private final String identifikation;
        private boolean vorhanden;

        Ueberpruefung(String identifikation) {
            this.identifikation = identifikation;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Ueberwachung ueberwachung = (Ueberwachung)event.getSource();
            if (!this.vorhanden) {
                ueberwachung.stop();
                Leitung.this.ueberpruefungen.remove(this.identifikation);
                Leitung.this.veranstaltungskandidaten.remove(this.identifikation);
                Leitung.this.identifikationen = Leitung.this.identifikationen();
                Leitung.this.fireTableDataChanged();
            }
            this.vorhanden = false;
        }

        void bestaetige() {
            this.vorhanden = true;
        }
    }

    private static class Ueberwachung
    extends Timer {
        private static final int UEBERWACHUNGSPERIODE = 5000;

        Ueberwachung(Ueberpruefung ueberpruefung) {
            super(5000, ueberpruefung);
        }
    }
}

