/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Grafik;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Verfolgung
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    private static final Color SCHRITTBESCHREIBUNGSFARBE = new Color(240, 255, 255);
    private static final Color LINIENFARBE = new Color(48, 128, 192);
    private static final int ABSTAND = 4;
    private static final float BOTFELDGEWICHT = 0.4f;
    private static final int BOTFELDBREITE = 125;
    private static final String SPIELER_MENSCH = "Mensch";
    private static final String SPIELER_BOT = "Card with JTextField";
    private static final ImageIcon WUERFELN = Grafik.icon("Wuerfeln.gif");
    private static final ImageIcon WUERFELN0 = Grafik.icon("Wuerfeln0.gif");
    private static final ImageIcon EINTRAG = Grafik.icon("Eintrag.gif");
    private static final ImageIcon FERTIG = Grafik.icon("Fertig.gif");
    private static final ImageIcon BOT = Grafik.icon("Bot.png");
    private final JLabel mensch = new JLabel(WUERFELN0);
    private final JLabel bot = new JLabel(BOT);
    private final JTextArea botschritt = new JTextArea(2, 5);
    private final JButton naechsteAktion = this.weiter(34);
    private final JButton alleAktionen = this.weiter(35);

    public Verfolgung() {
        super(new CardLayout());
        this.add((Component)this.menschkarte(), SPIELER_MENSCH);
        this.add((Component)this.botkarte(), SPIELER_BOT);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.mensch.addMouseListener(listener);
    }

    public void erledigeNaechsteAktion(int dauer) {
        this.naechsteAktion.doClick(dauer);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Object wert = event.getNewValue();
        if (name.equals("LongDescription")) {
            this.botschritt.setText((String)wert);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: {
                    this.starte();
                }
                case SPIEL: 
                case GEWUERFELT: 
                case GESETZT: 
                case RUECKGAENGIG: {
                    this.aktualisiere((Turnier)ce.getSource());
                    break;
                }
                case RESULTAT: {
                    this.verstecke();
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.beende();
                    break;
                }
            }
        }
    }

    public void verknuepfe(Action aktion, String anzeige, String hilfe) {
        aktion.addPropertyChangeListener(this);
        aktion.putValue("Name", anzeige);
        aktion.putValue("ShortDescription", hilfe);
        if (anzeige.equals("Anstehende Aktion")) {
            this.naechsteAktion.setAction(aktion);
        }
        if (anzeige.equals("Alle Aktionen")) {
            this.alleAktionen.setAction(aktion);
        }
    }

    private void aktualisiere(Turnier turnier) {
        Spieler aktiver = turnier.aktiver();
        CardLayout layout = (CardLayout)this.getLayout();
        boolean neu = aktiver.neu();
        boolean fertig = aktiver.fertig();
        if (aktiver.interaktiv()) {
            layout.show(this, SPIELER_MENSCH);
        } else {
            this.requestFocusInWindow();
            layout.show(this, SPIELER_BOT);
        }
        this.mensch.setEnabled(!neu);
        this.mensch.setIcon(fertig ? EINTRAG : WUERFELN0);
        this.bot.setEnabled(true);
    }

    private void beende() {
        this.mensch.setDisabledIcon(FERTIG);
        this.mensch.setEnabled(false);
        this.bot.setEnabled(false);
    }

    private JPanel botfeld(String titel, String hilfe) {
        JPanel feld = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(125, super.getPreferredSize().height);
            }
        };
        feld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, titel, 2, 2, null, Color.BLUE), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        feld.setToolTipText(hilfe);
        return feld;
    }

    private JPanel botkarte() {
        this.botschritt.setLineWrap(true);
        this.botschritt.setWrapStyleWord(true);
        this.botschritt.setEditable(false);
        this.botschritt.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(LINIENFARBE), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.botschritt.setBackground(SCHRITTBESCHREIBUNGSFARBE);
        this.bot.setBorder(BorderFactory.createEtchedBorder());
        this.bot.setEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        JPanel aktion = this.botfeld("Anstehende Aktion", "Beschreibung der Aktion, welche der Bot als n\u00e4chstes ausf\u00fchren m\u00f6chte.");
        aktion.setLayout(new GridBagLayout());
        c.fill = 2;
        c.gridx = 0;
        c.weightx = 1.0;
        aktion.add((Component)this.botschritt, c);
        JPanel bestaetigung = this.botfeld("Best\u00e4tigung", "Anstehende Bot-Aktion zur Kenntnis genommen, Best\u00e4tigung zum Weitermachen");
        bestaetigung.setLayout(new GridLayout(2, 1, 0, 4));
        bestaetigung.add(this.alleAktionen);
        bestaetigung.add(this.naechsteAktion);
        JPanel feld = new JPanel();
        feld.setLayout(new GridBagLayout());
        c.fill = 1;
        c.gridx = 0;
        c.weightx = 0.4f;
        c.weighty = 1.0;
        feld.add((Component)aktion, c);
        c.fill = 0;
        c.gridx = 1;
        c.weightx = 0.19999998807907104;
        feld.add((Component)this.bot, c);
        c.fill = 1;
        c.gridx = 2;
        c.weightx = 0.4f;
        feld.add((Component)bestaetigung, c);
        return feld;
    }

    private JPanel menschkarte() {
        this.mensch.setToolTipText("Sortieren durch Doppelklick, Kontextmen\u00fc");
        this.mensch.setBorder(BorderFactory.createEtchedBorder());
        this.mensch.setAlignmentX(0.5f);
        this.mensch.setEnabled(false);
        JPanel feld = new JPanel();
        feld.setLayout(new BoxLayout(feld, 3));
        feld.add(Box.createVerticalGlue());
        feld.add(this.mensch);
        feld.add(Box.createVerticalGlue());
        return feld;
    }

    private void starte() {
        this.mensch.setDisabledIcon(WUERFELN);
    }

    private void verstecke() {
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show(this, SPIELER_MENSCH);
    }

    private JButton weiter(int taste) {
        JButton weiter = new JButton();
        weiter.setMargin(new Insets(2, 0, 2, 0));
        weiter.getInputMap(2).put(KeyStroke.getKeyStroke(taste, 0), weiter);
        weiter.getActionMap().put(weiter, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JButton weiter = (JButton)event.getSource();
                weiter.doClick();
            }
        });
        return weiter;
    }
}

