/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.logik.Statistik;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

class Verlaufstabelle
extends JTable {
    private static final int ZWISCHENRAUM = 8;

    Verlaufstabelle() {
        this.getTableHeader().setDefaultRenderer(new Kopf());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.setAutoResizeMode(0);
        this.setAutoCreateRowSorter(true);
        this.setRowSelectionAllowed(false);
        this.setToolTipText("Die Tabelle ist sortierbar durch Anklicken der Spaltenk\u00f6pfe");
    }

    @Override
    public TableCellRenderer getCellRenderer(int zeile, int spalte) {
        if (spalte > 0) {
            return new Punktzahl();
        }
        return new Spielnummer();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int zeile, int spalte) {
        DefaultTableCellRenderer zelle = (DefaultTableCellRenderer)super.prepareRenderer(renderer, zeile, spalte);
        zelle.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        return zelle;
    }

    private void springe(final int zeile) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Verlaufstabelle.this.scrollRectToVisible(Verlaufstabelle.this.getCellRect(Verlaufstabelle.this.getRowSorter().convertRowIndexToView(zeile), 0, true));
            }
        });
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent event) {
                int geometrischerIndex = this.columnModel.getColumnIndexAtX(event.getPoint().x);
                int logischerIndex = this.columnModel.getColumn(geometrischerIndex).getModelIndex();
                return logischerIndex == 0 ? "Laufende Nummern des Spiels im Turniers" : "Endsummen f\u00fcr den genannten Spieler zu Spielen mit den laufenden Nummern";
            }
        };
    }

    void aktualisiere() {
        Adapter adapter = (Adapter)this.getModel();
        int zeile = adapter.getRowCount() - 1;
        adapter.fireTableRowsUpdated(zeile, zeile);
    }

    void beende() {
        Adapter adapter = (Adapter)this.getModel();
        adapter.fireTableDataChanged();
        this.springe(adapter.getRowCount() - 1);
        this.revalidate();
    }

    void starte(Statistik statistik) {
        Adapter adapter = new Adapter(statistik);
        this.setModel(adapter);
        adapter.fireTableStructureChanged();
        int zeile = adapter.getRowCount() - 1;
        this.springe(zeile);
    }

    private static class Adapter
    extends AbstractTableModel {
        private final Statistik statistik;

        Adapter(Statistik statistik) {
            this.statistik = statistik;
        }

        @Override
        public Class<?> getColumnClass(int spalte) {
            return Integer.class;
        }

        @Override
        public int getColumnCount() {
            return 1 + this.statistik.teilnehmer().size();
        }

        @Override
        public String getColumnName(int spalte) {
            if (spalte > 0) {
                return this.statistik.teilnehmer().get(spalte - 1).toString();
            }
            return "Nummer";
        }

        @Override
        public int getRowCount() {
            return this.statistik.spielanzahl();
        }

        @Override
        public Object getValueAt(int zeile, int spalte) {
            if (spalte > 0) {
                return this.statistik.verlaeufe().get(this.statistik.teilnehmer().get(spalte - 1).index()).get(zeile);
            }
            return zeile + 1;
        }
    }

    private static class Kopf
    extends JLabel
    implements TableCellRenderer {
        private final Color schriftfarbe = this.getForeground();

        Kopf() {
            this.setHorizontalAlignment(4);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 8, 0, 8)));
        }

        @Override
        public Component getTableCellRendererComponent(JTable tabelle, Object wert, boolean selektiert, boolean fokussiert, int zeile, int spalte) {
            if (spalte > 0) {
                this.setFont(this.getFont().deriveFont(0));
                this.setForeground(this.schriftfarbe);
            } else {
                this.setFont(this.getFont().deriveFont(2));
                this.setForeground(Color.GRAY);
            }
            this.setText("<html>" + this.sortierrichtung(tabelle, spalte) + wert.toString() + "</html>");
            return this;
        }

        private String sortierrichtung(JTable tabelle, int spalte) {
            List<RowSorter.SortKey> sortierschluessel = tabelle.getRowSorter().getSortKeys();
            if (sortierschluessel.isEmpty() || sortierschluessel.get(0).getColumn() != spalte) {
                return "";
            }
            switch (sortierschluessel.get(0).getSortOrder()) {
                case ASCENDING: {
                    return "&uarr;";
                }
                case DESCENDING: {
                    return "&darr;";
                }
            }
            return "";
        }
    }

    private static class Punktzahl
    extends DefaultTableCellRenderer {
        Punktzahl() {
            this.setHorizontalAlignment(4);
            this.setFont(this.getFont().deriveFont(0));
        }

        @Override
        public Component getTableCellRendererComponent(JTable tabelle, Object wert, boolean selektiert, boolean fokussiert, int zeile, int spalte) {
            int max = 0;
            int j = 1;
            while (j < tabelle.getColumnCount()) {
                max = Integer.max(max, (Integer)tabelle.getValueAt(zeile, j));
                ++j;
            }
            if (max == (Integer)wert) {
                this.setForeground(Color.PINK.darker());
            }
            this.setText(wert.toString());
            return this;
        }
    }

    private static class Spielnummer
    extends DefaultTableCellRenderer {
        Spielnummer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
            this.setHorizontalAlignment(4);
            this.setFont(this.getFont().deriveFont(2));
            this.setForeground(Color.GRAY);
        }

        @Override
        public Component getTableCellRendererComponent(JTable tabelle, Object wert, boolean selektiert, boolean fokussiert, int zeile, int spalte) {
            this.setText(wert.toString());
            return this;
        }
    }
}

