/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Becher;
import jafuffy.bedienung.Setzen;
import jafuffy.bedienung.Verfolgung;
import jafuffy.bedienung.Vorschlagen;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import jafuffy.logik.Wuerfel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Aufsicht
implements ChangeListener {
    private static final int AKTIONSDAUER_DEUTLICH = 400;
    private static final int AKTIONSDAUER_SCHNELL = 200;
    private static boolean optimiert;
    public static final String ANSTEHENDE_AKTION = "Anstehende Aktion";
    public static final String ALLE_AKTIONEN = "Alle Aktionen";
    private final Action alleAktionen = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Aufsicht.this.botkontrolliert = true;
            Aufsicht.this.schritt.mache(event);
        }
    };
    private final Action naechsteAktion = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            Aufsicht.this.schritt.mache(event);
        }
    };
    private final Eigenschaften eigenschaften;
    private final Becher becher;
    private final Vorschlagen vorschlagen;
    private final Setzen setzen;
    private final Verfolgung verfolgung;
    private final Ueberlegungsaktion ueberlegungsaktion = new Ueberlegungsaktion();
    private final Wurfaktion wurfaktion = new Wurfaktion();
    private final Setzaktion setzaktion = new Setzaktion();
    private final Pausenaktion pausenaktion = new Pausenaktion();
    private Turnier turnier;
    private Spieler aktiver;
    private Schritt schritt;
    private boolean botkontrolliert;

    public static void simuliere() {
        optimiert = true;
    }

    Aufsicht(Eigenschaften eigenschaften, Vorschlagen vorschlagen, Becher becher, Verfolgung verfolgung, Setzen setzen) {
        this.eigenschaften = eigenschaften;
        this.becher = becher;
        this.vorschlagen = vorschlagen;
        this.setzen = setzen;
        this.verfolgung = verfolgung;
        verfolgung.verknuepfe(this.alleAktionen, ALLE_AKTIONEN, "<html>Bot soll alle seine anstehenden Aktionen abschlie\u00dfen und dann die W\u00fcrfel abgeben.<br><small>Mausklick oder Taste \"Ende\"</small></html>");
        verfolgung.verknuepfe(this.naechsteAktion, ANSTEHENDE_AKTION, "<html>Bot soll nur mit seiner n\u00e4chsten anstehenden Aktion weitermachen.<br><small>Mausklick oder Taste \"Bild ab\"</small></html>");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy cej = CEJaFuffy.ereignisbehaelter(ce);
            this.turnier = (Turnier)cej.quelle(Turnier.class);
            this.aktiver = this.turnier.aktiver();
            if (this.aktiver.interaktiv()) {
                return;
            }
            this.botkontrolliert = this.botkontrolliert || this.geisterhaft();
            switch ((CEAblauf)((Object)cej.ereignis())) {
                case START: 
                case SPIEL: {
                    this.naechsteAktion.setEnabled(true);
                    this.alleAktionen.setEnabled(true);
                    this.registriere(this.wurfaktion);
                    this.bearbeite(this.botkontrolliert);
                    break;
                }
                case RESULTAT: 
                case ENDE: {
                    this.registriere(this.pausenaktion);
                    this.bearbeite(this.botkontrolliert);
                    this.botkontrolliert = false;
                    break;
                }
                case GESETZT: {
                    this.registriere(this.wurfaktion);
                    this.botkontrolliert = this.geisterhaft();
                    this.bearbeite(this.botkontrolliert);
                    break;
                }
                case GEWUERFELT: {
                    this.registriere(this.ueberlegungsaktion);
                    this.bearbeite(this.knapper() || this.botkontrolliert);
                    break;
                }
            }
        }
    }

    private int aktionsdauer() {
        int dauer = optimiert ? 0 : (this.eigenschaften.aktiv("Aktionsbeschleunigung") ? 200 : 400);
        if (this.botkontrolliert) {
            dauer *= 2;
        }
        return dauer;
    }

    private boolean geisterhaft() {
        return this.eigenschaften.aktiv("Geisterhand");
    }

    private boolean knapper() {
        return !this.eigenschaften.aktiv("Ueberlegungsbestaetigung");
    }

    private void registriere(Schritt schritt) {
        this.schritt = schritt;
        this.naechsteAktion.putValue("LongDescription", this.aktiver + schritt.toString());
    }

    private void bearbeite(boolean aktiv) {
        if (this.geisterhaft() || aktiv) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Aufsicht.this.verfolgung.erledigeNaechsteAktion(Aufsicht.this.aktionsdauer());
                }
            });
        }
    }

    private boolean wuerfelbereit() {
        Wuerfel[] wuerfelArray = this.turnier.wuerfelsatz();
        int n = wuerfelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel wuerfel = wuerfelArray[n2];
            if (wuerfel.darstellungsmodell().isSelected()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private class Pausenaktion
    implements Schritt {
        private Pausenaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.alleAktionen.setEnabled(false);
            Aufsicht.this.naechsteAktion.setEnabled(false);
        }

        public String toString() {
            return " hat keine weitere Aktion vor.";
        }
    }

    private static interface Schritt {
        public void mache(ActionEvent var1);
    }

    private class Setzaktion
    implements Schritt {
        private Setzaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.setzen.doClick();
            Aufsicht.this.alleAktionen.setEnabled(true);
            Aufsicht.this.botkontrolliert = false;
        }

        public String toString() {
            return " m\u00f6chte jetzt setzen.";
        }
    }

    private class Ueberlegungsaktion
    implements Schritt {
        private Ueberlegungsaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.vorschlagen.doClick();
            if (Aufsicht.this.wuerfelbereit()) {
                Aufsicht.this.registriere(Aufsicht.this.wurfaktion);
            } else {
                Aufsicht.this.registriere(Aufsicht.this.setzaktion);
            }
            Aufsicht.this.bearbeite(Aufsicht.this.botkontrolliert);
        }

        public String toString() {
            return Aufsicht.this.knapper() ? " \u00fcberlegt jetzt." : " m\u00f6chte jetzt \u00fcberlegen.";
        }
    }

    private class Wurfaktion
    implements Schritt {
        private Wurfaktion() {
        }

        @Override
        public void mache(ActionEvent event) {
            Aufsicht.this.becher.doClick();
            Aufsicht.this.alleAktionen.setEnabled(false);
        }

        public String toString() {
            return Aufsicht.this.knapper() ? " m\u00f6chte jetzt w\u00fcrfeln und \u00fcberlegen." : " m\u00f6chte jetzt w\u00fcrfeln.";
        }
    }
}

