/******************************************************************************
 ** $Id: Wechselfeld.java 1616 2018-12-30 23:29:17Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.bedienung;

import java.awt.CardLayout;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import jafuffy.logik.CEAblauf;
import jafuffy.logik.CEJaFuffy;
import jafuffy.logik.Turnier;

/**
 * Wechselfeld fr Wrfelauswahl, Inhalt je nach Spielphase ist eine Reihe aus Wrfeln oder ein leeres Feld.
 */
@SuppressWarnings("serial")
class Wechselfeld extends JPanel implements ChangeListener {

    /** uerer Abstand zum Wechselfeld. */
    private static final int WUERFELRAHMENABSTAND = 4;

    /** Versteckphase fr Wechselfeld. */
    private static final String VERSTECK = "Versteck";
    /** Anzeigephase fr Wechselfeld. */
    private static final String ANZEIGE = "Anzeige";

    /**
     * Konstruktion des Wechselfeldes.
     *
     * @param reihe
     *            Die Wrfelreihe, die hier eingefgt wird.
     */
    Wechselfeld(Wuerfelreihe reihe) {
        super(new CardLayout());
        setBorder(BorderFactory.createCompoundBorder(
                BorderFactory.createTitledBorder(null, "Wrfelauswahl", TitledBorder.CENTER, TitledBorder.TOP),
                BorderFactory.createEmptyBorder(0, WUERFELRAHMENABSTAND / 2, WUERFELRAHMENABSTAND,
                        WUERFELRAHMENABSTAND / 2)));
        add(new JPanel(), VERSTECK);
        add(reihe, ANZEIGE);
        setToolTipText("Sortieren durch Doppelklick auf freie Flche, Kontextmen");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (CEJaFuffy.adressiert(ce, CEAblauf.class)) {
            CEJaFuffy<CEAblauf> cej = CEJaFuffy.ereignisbehaelter(ce);
            switch (cej.ereignis()) {
            case START:
            case SPIEL:
            case GESETZT:
            case GEWUERFELT:
            case RUECKGAENGIG:
                aktualisiere((Turnier) ce.getSource());
                break;
            case RESULTAT:
                verstecke();
                break;
            case ABBRUCH:
            case ENDE:
                setEnabled(false);
                break;
            default:
                break;
            }
        }
    }

    /**
     * Aktualisiert das Wechselfeld.
     *
     * @param turnier
     *            Das Turnier, fr welches das Wechselfeld aktualisiert wird.
     */
    private void aktualisiere(Turnier turnier) {
        boolean neu = turnier.aktiver().neu();
        boolean interaktiv = turnier.aktiver().interaktiv();
        setEnabled(!neu && interaktiv);
        ((CardLayout) getLayout()).show(this, neu ? VERSTECK : ANZEIGE);
    }

    /** Versteckt die Wrfelauswahl. */
    private void verstecke() {
        ((CardLayout) getLayout()).show(this, VERSTECK);
    }

}
