/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

public enum Kategorie {
    EINS("1er", "Nur Einser z\u00e4hlen", Art.OBEN),
    ZWEI("2er", "Nur Zweier z\u00e4hlen", Art.OBEN),
    DREI("3er", "Nur Dreier z\u00e4hlen", Art.OBEN),
    VIER("4er", "Nur Vierer z\u00e4hlen", Art.OBEN),
    FUENF("5er", "Nur F\u00fcnfer z\u00e4hlen", Art.OBEN),
    SECHS("6er", "Nur Sechser z\u00e4hlen", Art.OBEN),
    GESAMT("Gesamt", "Summe der oberen Eintr\u00e4ge"),
    BONUS("Bonus ab 63", "Ab 63 Punkten oben zus\u00e4tzlich 35 Bonuspunkte"),
    OSUMME("Obere Summe", "Summe der oberen Eintr\u00e4ge plus Bonuspunkte"),
    DREIERPASCH("Dreierpasch", "Alle Augen z\u00e4hlen", Art.UNTEN),
    VIERERPASCH("Viererpasch", "Alle Augen z\u00e4hlen", Art.UNTEN),
    FULLHOUSE("Full-House", "25 Punkte", Art.UNTEN),
    KLEINESTRASSE("Kleine Stra\u00dfe", "30 Punkte", Art.UNTEN),
    GROSSESTRASSE("Gro\u00dfe Stra\u00dfe", "40 Punkte", Art.UNTEN),
    JAFUFFY("JaFuffy", "50 Punkte", Art.UNTEN),
    CHANCE("Chance", "Alle Augen z\u00e4hlen", Art.UNTEN),
    USUMME("Untere Summe", "Summe der unteren Eintr\u00e4ge"),
    ESUMME("Endsumme", "Obere und untere Summe zusammen");

    public static final Kategorie[] SETZBAR;
    public static final int ANZAHL;
    public static final Kategorie[] OBEN;
    public static final Kategorie[] UNTEN;
    private final Art art;
    private final String beschreibung;
    private final String bezeichnung;

    static {
        SETZBAR = new Kategorie[]{EINS, ZWEI, DREI, VIER, FUENF, SECHS, DREIERPASCH, VIERERPASCH, FULLHOUSE, KLEINESTRASSE, GROSSESTRASSE, JAFUFFY, CHANCE};
        ANZAHL = Kategorie.values().length;
        OBEN = new Kategorie[]{EINS, ZWEI, DREI, VIER, FUENF, SECHS};
        UNTEN = new Kategorie[]{DREIERPASCH, VIERERPASCH, FULLHOUSE, KLEINESTRASSE, GROSSESTRASSE, JAFUFFY, CHANCE};
    }

    public static Kategorie kategorie(int index) {
        return Kategorie.values()[index];
    }

    public static Kategorie oben(int augen) {
        return Kategorie.kategorie(augen - 1);
    }

    private Kategorie(String bezeichnung, String beschreibung) {
        this(bezeichnung, beschreibung, Art.DERIVAT);
    }

    private Kategorie(String bezeichnung, String beschreibung, Art art) {
        this.bezeichnung = bezeichnung;
        this.beschreibung = beschreibung;
        this.art = art;
    }

    public boolean alle() {
        return this.oben() || this.unten();
    }

    public String beschreibung() {
        return this.beschreibung;
    }

    public String bezeichnung() {
        return this.bezeichnung;
    }

    public boolean oben() {
        return this.art == Art.OBEN;
    }

    public boolean unten() {
        return this.art == Art.UNTEN;
    }

    private static enum Art {
        DERIVAT,
        OBEN,
        UNTEN;

    }
}

