/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.bedienung.auswahl.Auswahl;
import jafuffy.logik.Aenderungen;
import jafuffy.logik.Beginner;
import jafuffy.logik.CEAblauf;
import jafuffy.logik.Kategorie;
import jafuffy.logik.Punkte;
import jafuffy.logik.Spieler;
import jafuffy.logik.Statistik;
import jafuffy.logik.Variante;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.analyse.Analyse;
import jafuffy.logik.auswertung.Auswertung;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Random;

public class Turnier
extends Aenderungen<CEAblauf>
implements ActionListener,
Serializable {
    private static final long serialVersionUID = -8157448193770055452L;
    private static final Random ZUFALL = new Random();
    private static final int KATEGORIENANZAHL = 13;
    public static final int WUERFELSATZGROESSE = 5;
    public static final int WURFVERSUCHANZAHL = 3;
    private final Wuerfel[] wuerfelsatz;
    private final Variante variante;
    private final ArrayList<Spieler> teilnehmer;
    private final Auswertung auswertung;
    private final int maximalanzahl;
    private final Beginner beginnmodus;
    private final Fortschritt fortschritt = new Fortschritt();
    private final Fortschritt zwischenschritt = new Fortschritt();
    private ArrayList<ArrayList<Integer>> verlaeufe;
    private ArrayList<Integer> turnierstaende;
    private Kategorie eintragsmerker;
    private Spieler standmerker;
    private transient Statistik statistik;
    private transient Punkte punkte;

    public Turnier(Variante variante, ArrayList<Spieler> teilnehmer, Spieler erster, Beginner beginnmodus, int anzahl) {
        this.variante = variante;
        this.teilnehmer = teilnehmer;
        this.beginnmodus = beginnmodus;
        this.maximalanzahl = anzahl;
        this.wuerfelsatz = new Wuerfel[5];
        int i = 0;
        while (i < 5) {
            this.wuerfelsatz[i] = new Wuerfel(i + 1);
            ++i;
        }
        this.auswertung = variante.auswertung(this.wuerfelsatz);
        for (Spieler spieler : teilnehmer) {
            spieler.initialisiere();
        }
        this.fortschritt.aktiver = erster;
        erster.aktiviere();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String ac = event.getActionCommand();
        if (ac.equals("Gewuerfelt")) {
            this.wuerfle();
        } else if (ac.equals("Rueckgaengig")) {
            this.annulliere();
        } else if (ac.equals("Vorschlagen")) {
            this.auswertung.erstelleVorschlag();
        } else if (ac.equals("Beenden")) {
            this.beende();
        }
    }

    public Spieler aktiver() {
        return this.fortschritt.aktiver;
    }

    public Auswahl auswahl() {
        return this.variante.auswahl(this);
    }

    public Auswertung auswertung() {
        return this.auswertung;
    }

    public void beende() {
        if (this.fortschritt.aktiver != null) {
            this.auswertung.aktiviereTipps(false);
            this.fireStateChanged(this.fortschritt.spielindex == this.maximalanzahl && this.maximalanzahl > 0 ? CEAblauf.ENDE : CEAblauf.ABBRUCH);
            this.fortschritt.aktiver.beende();
            this.fortschritt.aktiver = null;
        }
    }

    public boolean beendet() {
        return this.fortschritt.aktiver == null;
    }

    public void belege(Kategorie kategorie) {
        this.fortschritt.aktiver.belege(kategorie, this.auswertung.analyse());
    }

    public String beschreibung() {
        String s = new String("Mitspieler: ");
        ListIterator<Spieler> iterator = this.teilnehmer.listIterator();
        while (iterator.hasNext()) {
            s = String.valueOf(s) + iterator.next().toString();
            s = iterator.hasNext() ? String.valueOf(s) + ", " : String.valueOf(s) + ".";
        }
        s = String.valueOf(s) + "\n" + this.auswertung.toString() + ". " + (this.teilnehmer.size() > 1 ? (Object)((Object)this.beginnmodus) + ". " : "");
        s = String.valueOf(s) + (this.maximalanzahl == 0 ? "Beliebig viele Spiele." : "Im " + (this.fortschritt.spielindex + 1) + ". von " + this.maximalanzahl + (this.maximalanzahl != 1 ? " Spielen" : " Spiel") + ".");
        return s;
    }

    public int maximalanzahl() {
        return this.maximalanzahl;
    }

    public void pausiere() {
        this.fireStateChanged(CEAblauf.PAUSE);
    }

    public Punkte punkte() {
        return this.punkte;
    }

    public boolean ruecknahmefaehig() {
        return this.zwischenschritt.aktiver.interaktiv();
    }

    public void setze(Kategorie kategorie) {
        this.standmerker = this.fortschritt.setze(this.zwischenschritt, kategorie, this.auswertung.analyse());
        this.eintragsmerker = kategorie;
        this.punkte.benachrichtige(this.fortschritt.aktiver.index());
        this.beendeSetzen();
    }

    public void setzeFort(Statistik statistik) {
        this.statistik = statistik;
        this.auswertung.reagiereAufWurf(this.fortschritt.aktiver);
        this.punkte = new Punkte(this.teilnehmer, this.auswertung);
        if (this.verlaeufe == null) {
            this.verlaeufe = new ArrayList(this.teilnehmer.size());
            this.turnierstaende = new ArrayList(this.teilnehmer.size());
            for (Spieler spieler : this.teilnehmer) {
                this.verlaeufe.add(spieler.index(), new ArrayList());
                this.verlaeufe.get(spieler.index()).add(0);
                this.turnierstaende.add(spieler.index(), 0);
            }
        }
        statistik.verfolge(this.variante, this.maximalanzahl, this.teilnehmer, this.auswertung.mittelwert(), this.auswertung.abweichung(), this.verlaeufe, this.turnierstaende);
    }

    public int spielnummer() {
        return this.fortschritt.spielindex + 1;
    }

    public void starte() {
        this.fireStateChanged(CEAblauf.START);
        if (!this.fortschritt.aktiver.neu()) {
            this.fireStateChanged(CEAblauf.GEWUERFELT);
        }
    }

    public ArrayList<Spieler> teilnehmer() {
        return this.teilnehmer;
    }

    public boolean vorschlagbar() {
        return this.fortschritt.aktiver.gewuerfelt();
    }

    public Wuerfel wuerfel(int i) {
        return this.wuerfelsatz[i];
    }

    public Wuerfel[] wuerfelsatz() {
        return this.wuerfelsatz;
    }

    private void annulliere() {
        if (this.fortschritt.eintragsanzahl != this.zwischenschritt.eintragsanzahl) {
            this.statistik.annulliere();
        }
        this.fortschritt.annulliere(this.zwischenschritt, this.standmerker, this.eintragsmerker, this.auswertung);
        Wuerfel[] wuerfelArray = this.wuerfelsatz;
        int n = this.wuerfelsatz.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel wuerfel = wuerfelArray[n2];
            wuerfel.darstellungsmodell().setSelected(false);
            ++n2;
        }
        this.fireStateChanged(CEAblauf.RUECKGAENGIG);
    }

    private void beendeRunde() {
        Fortschritt fortschritt = this.fortschritt;
        fortschritt.eintragsanzahl = fortschritt.eintragsanzahl + 1;
        this.fortschritt.spielerindex = 0;
        this.statistik.beendeRunde();
    }

    private void beendeSetzen() {
        this.fortschritt.aktiver = this.naechster();
        this.fortschritt.aktiver.aktiviere();
        Fortschritt fortschritt = this.fortschritt;
        fortschritt.spielerindex = fortschritt.spielerindex + 1;
        if (this.fortschritt.spielerindex >= this.teilnehmer.size()) {
            this.beendeRunde();
            if (this.fortschritt.eintragsanzahl >= 13) {
                this.fortschritt.aktiver.beende();
                this.auswertung.aktiviereTipps(false);
                this.fireStateChanged(CEAblauf.RESULTAT);
                this.beendeSpiel();
            }
        }
        if (this.maximalanzahl > 0 && this.fortschritt.spielindex == this.maximalanzahl) {
            this.beende();
        } else if (this.fortschritt.spielindex == this.zwischenschritt.spielindex) {
            this.auswertung.aktiviereTipps(false);
            this.fireStateChanged(CEAblauf.GESETZT);
        } else {
            this.fireStateChanged(CEAblauf.SPIEL);
        }
    }

    private void beendeSpiel() {
        Spieler erster = this.eroeffner();
        this.statistik.beendeSpiel();
        for (Spieler spieler : this.teilnehmer) {
            spieler.initialisiere();
        }
        this.fortschritt.aktiver = erster;
        this.fortschritt.aktiver.aktiviere();
        Fortschritt fortschritt = this.fortschritt;
        fortschritt.spielindex = fortschritt.spielindex + 1;
        this.fortschritt.eintragsanzahl = 0;
    }

    private Spieler eroeffner() {
        Spieler eroeffner;
        Spieler verlierer;
        Spieler gewinner = verlierer = this.teilnehmer.get(0);
        for (Spieler spieler : this.teilnehmer) {
            if (spieler.endsumme() < verlierer.endsumme()) {
                verlierer = spieler;
            }
            if (spieler.endsumme() <= gewinner.endsumme()) continue;
            gewinner = spieler;
        }
        switch (this.beginnmodus) {
            case VERLIERER: {
                eroeffner = verlierer;
                break;
            }
            case GEWINNER: {
                eroeffner = gewinner;
                break;
            }
            case REIHUM: {
                eroeffner = this.naechster();
                break;
            }
            case ZUFALL: {
                eroeffner = this.teilnehmer.get(ZUFALL.nextInt(this.teilnehmer.size()));
                break;
            }
            case DERSELBE: {
                eroeffner = this.fortschritt.aktiver;
                break;
            }
            default: {
                eroeffner = null;
            }
        }
        return eroeffner;
    }

    private Spieler naechster() {
        return this.teilnehmer.get((this.fortschritt.aktiver.index() + 1) % this.teilnehmer.size());
    }

    private void wuerfle() {
        Wuerfel[] wuerfelArray = this.wuerfelsatz;
        int n = this.wuerfelsatz.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel wuerfel = wuerfelArray[n2];
            if (wuerfel.darstellungsmodell().isSelected()) {
                wuerfel.wirf();
            }
            ++n2;
        }
        this.fireStateChanged(CEAblauf.WUERFELN);
        this.fortschritt.aktiver.reagiere();
        this.auswertung.reagiereAufWurf(this.fortschritt.aktiver);
        this.auswertung.aktiviereTipps(false);
        this.fireStateChanged(CEAblauf.GEWUERFELT);
    }

    Spieler spieler(int i) {
        return this.teilnehmer.get(i);
    }

    private static class Fortschritt
    implements Serializable {
        private static final long serialVersionUID = 8968279815699993227L;
        private Spieler aktiver;
        private int spielerindex = 0;
        private int spielindex = 0;
        private int eintragsanzahl = 0;

        private Fortschritt() {
        }

        Spieler setze(Fortschritt schritt, Kategorie kategorie, Analyse analyse) {
            schritt.aktiver = this.aktiver;
            schritt.spielerindex = this.spielerindex;
            schritt.spielindex = this.spielindex;
            schritt.eintragsanzahl = this.eintragsanzahl;
            Spieler spieler = this.aktiver.clone();
            this.aktiver.belege(kategorie, analyse);
            this.aktiver.beende();
            return spieler;
        }

        void annulliere(Fortschritt schritt, Spieler spieler, Kategorie kategorie, Auswertung auswertung) {
            this.aktiver.beende();
            this.aktiver = schritt.aktiver;
            this.spielerindex = schritt.spielerindex;
            this.spielindex = schritt.spielindex;
            this.eintragsanzahl = schritt.eintragsanzahl;
            this.aktiver.annulliere(spieler, kategorie, auswertung.analyse());
            auswertung.reagiereAufWurf(this.aktiver);
            auswertung.aktiviereTipps(false);
        }
    }
}

