/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.organisation;

import jafuffy.organisation.Kontakt;
import jafuffy.organisation.Nachricht;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

class Anmeldung
extends Timer {
    private static final int PERIODE = 1000;
    private final Kontakt absender;
    private final ArrayList<String> teilnehmer;
    private final MulticastSocket socket;

    Anmeldung(Kontakt absender, ArrayList<String> teilnehmer, MulticastSocket socket) {
        this.absender = absender;
        this.teilnehmer = teilnehmer;
        this.socket = socket;
    }

    private void serialisiere(Object object) throws IOException, SocketException {
        ByteArrayOutputStream bytestrom = new ByteArrayOutputStream();
        ObjectOutputStream objektstrom = new ObjectOutputStream(new BufferedOutputStream(bytestrom));
        objektstrom.writeObject(object);
        objektstrom.close();
        byte[] bytes = bytestrom.toByteArray();
        bytestrom.close();
        DatagramPacket paket = new DatagramPacket(bytes, bytes.length, InetAddress.getByName("239.255.255.136"), 54815);
        this.socket.send(paket);
    }

    void sende(Nachricht nachricht) {
        try {
            this.serialisiere(nachricht);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    void starte() {
        this.scheduleAtFixedRate((TimerTask)new Wiederholung(), 0L, 1000L);
    }

    private class Wiederholung
    extends TimerTask {
        private Wiederholung() {
        }

        @Override
        public void run() {
            try {
                Anmeldung.this.serialisiere(new Nachricht(Anmeldung.this.absender, Anmeldung.this.teilnehmer, null));
            }
            catch (SocketException exception) {
                this.cancel();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }
}

