/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Ressource;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Signal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class Hilfe
extends JDialog
implements PropertyChangeListener,
HyperlinkListener {
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int FELDRAHMENABSTAND = 4;
    private static final int BUTTONABSTAND = 8;
    private static final int BREITE = 640;
    private static final int HOEHE = 448;
    private static final URL STARTSEITE = Ressource.ANLEITUNG.url("index.html");
    private final JEditorPane browser = new JEditorPane();
    private final Stack<URL> history = new Stack();
    private final JButton inhalt = new JButton("Zum Hilfebeginn");
    private URL seite = STARTSEITE;
    private final JButton zurueck = new JButton("Schritt zur\u00fcck");

    Hilfe() throws Exception {
        UIManager.addPropertyChangeListener(this);
        this.browser.setPage(this.seite);
        this.browser.setEditable(false);
        this.browser.addHyperlinkListener(this);
        this.inhalt.addActionListener(event -> {
            try {
                this.history.push(this.seite);
                this.seite = STARTSEITE;
                this.browser.setPage(this.seite);
                this.inhalt.setEnabled(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
        this.zurueck.addActionListener(event -> {
            try {
                this.seite = this.history.pop();
                this.browser.setPage(this.seite);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Signal.WARNUNG.play();
                JOptionPane.showMessageDialog(this, "Hilfe-Datei nicht gefunden!\nJava-Exception:\n" + exception, "JaFuffy (Warnung)", 2);
            }
            this.zurueck.setEnabled(!this.history.empty());
            this.inhalt.setEnabled(this.seite != STARTSEITE);
        });
        this.setTitle("JaFuffy (Hilfe " + (STARTSEITE.getProtocol().equals("http") ? "\u00fcber Internet" : "aus Installation") + ")");
        this.setIconImages(Oberflaeche.LOGOS);
        this.setContentPane(this.hilfefeld());
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.pack();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.history.push(this.seite);
                this.seite = event.getURL();
                this.browser.setPage(this.seite);
                this.zurueck.setEnabled(true);
                this.inhalt.setEnabled(this.seite != STARTSEITE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Signal.WARNUNG.play();
                JOptionPane.showMessageDialog(this, "Kann die folgende Seite nicht \u00f6ffnen:\n" + this.seite.toString() + "\n" + "Java-Exception:\n" + exception, "JaFuffy (Warnung)", 2);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        }
    }

    private JPanel hilfefeld() {
        JPanel hilfefeld = new JPanel(new BorderLayout(4, 4));
        hilfefeld.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JScrollPane scrollPane = new JScrollPane(this.browser);
        scrollPane.setPreferredSize(new Dimension(640, 448));
        hilfefeld.add((Component)scrollPane, "Center");
        hilfefeld.add((Component)this.leiste(), "South");
        return hilfefeld;
    }

    private JPanel leiste() {
        this.inhalt.setEnabled(false);
        this.zurueck.setEnabled(false);
        JPanel leiste = new JPanel(new GridLayout(1, 2, 8, 0));
        leiste.add(this.inhalt);
        leiste.add(this.zurueck);
        JButton beenden = new JButton("Hilfe beenden");
        beenden.requestFocus();
        beenden.addActionListener(e -> this.setVisible(false));
        this.getRootPane().setDefaultButton(beenden);
        leiste.add(beenden);
        return leiste;
    }
}

