/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.Ressource;
import jafuffy.bedienung.Bestenliste;
import jafuffy.bedienung.Botstaerke;
import jafuffy.bedienung.Fortsetzung;
import jafuffy.bedienung.Hilfe;
import jafuffy.bedienung.Info;
import jafuffy.bedienung.Lizenzierung;
import jafuffy.bedienung.Pfad;
import jafuffy.bedienung.Report;
import jafuffy.bedienung.Setzen;
import jafuffy.bedienung.Signal;
import jafuffy.bedienung.Vorschlagen;
import jafuffy.logik.Turnier;
import jafuffy.logik.Update;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Menue
extends JMenuBar
implements PropertyChangeListener,
ChangeListener {
    private static final String SANDBOX = "<html><p><strong>Funktion au\u00dfer Aufnahme:</strong> <i>JaFuffy</i> l\u00e4uft mit eingeschr\u00e4nkten Rechten.</p><p>Dies ist u.a. der Fall bei der Ausf\u00fchrung von <i>JaFuffy</i> per Java Web Start.</p><br><p>Zur Bereitstellung der Funktion bitte <i>JaFuffy</i> \u00fcber Homepage installieren.</p></html>";
    private final Report report;
    private final Bestenliste bestenliste;
    private final Fortsetzung fortsetzung;
    private final Update update;
    private final Botstaerke botstaerke;
    private final Info info = new Info();
    private final Lizenzierung lizenzierung = new Lizenzierung();
    private final JMenuItem speichern = new JMenuItem("Speichern");
    private final JMenuItem speichernUnter = new JMenuItem("Speichern unter...");
    private final JMenuItem berichten = new JMenuItem("Report");
    private final JMenuItem rueckgaengig = new JMenuItem("R\u00fcckg\u00e4ngig");
    private final JMenuItem beenden = new JMenuItem("Beenden");
    private final Eigenschaften eigenschaften;
    private final Vorschlagen vorschlagen;
    private final Setzen setzen;
    private boolean betrieb = false;
    private boolean netzwerk = false;

    public Menue(Eigenschaften eigenschaften, Vorschlagen vorschlagen, Setzen setzen, Report report, Bestenliste bestenliste, Fortsetzung fortsetzung, Update update) {
        this.eigenschaften = eigenschaften;
        this.vorschlagen = vorschlagen;
        this.setzen = setzen;
        this.report = report;
        this.bestenliste = bestenliste;
        this.fortsetzung = fortsetzung;
        this.update = update;
        this.botstaerke = new Botstaerke(eigenschaften);
        UIManager.addPropertyChangeListener(this);
        this.erzeugeTurniermenue();
        this.erzeugeStatistikmenue();
        this.erzeugeExtrasmenue();
        this.erzeugeEinstellungenmenue();
        this.erzeugeHilfemenue();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        if (name.equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
        } else if (name.equals("Speichern")) {
            this.speichern.setEnabled((Boolean)event.getNewValue());
        } else if (name.equals("Netzwerk")) {
            this.netzwerk = (Boolean)event.getNewValue();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (Umschlag.adressiert(ce, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(ce);
            Turnier turnier = (Turnier)umschlag.quelle();
            switch ((Ablauf)((Object)umschlag.ereignis())) {
                case START: {
                    this.meldeTurnierAn(turnier);
                    break;
                }
                case RESULTAT: {
                    this.aktualisiere(false, false, false);
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    this.meldeTurnierAb(turnier);
                    break;
                }
                case GEWORFEN: 
                case RUECKGAENGIG: {
                    this.aktualisiere(true, false, false);
                    break;
                }
                case FERTIG: {
                    this.aktualisiere(false, false, turnier.ruecknahmefaehig() && !this.netzwerk);
                    break;
                }
            }
        }
    }

    private void aktualisiere(boolean vorschlagbar, boolean setzbar, boolean ruecknahmefaehig) {
        this.vorschlagen.setEnabled(vorschlagbar);
        this.setzen.setEnabled(setzbar);
        this.rueckgaengig.setEnabled(ruecknahmefaehig);
    }

    private JMenu botkontrolle() {
        JMenu untermenue = new JMenu("Botverhalten");
        untermenue.setToolTipText("<html>Ein Bot ist ein Gegenspieler, dessen Rolle von <i>JaFuffy</i> \u00fcbernommen wird.</html>");
        JMenuItem eintrag = untermenue.add(new JMenuItem("Spielst\u00e4rke der Bots..."));
        eintrag.setToolTipText("Spielst\u00e4rke der einzelnen Bots einstellen oder ansehen");
        eintrag.addActionListener(ereignis -> {
            this.botstaerke.setLocationRelativeTo(SwingUtilities.getRootPane(this));
            this.botstaerke.setVisible(true);
        });
        untermenue.addSeparator();
        eintrag = untermenue.add(new JCheckBoxMenuItem("Zeitlich kurze Darstellung"));
        eintrag.setToolTipText("Falls ausgew\u00e4hlt werden Aktionen des Bots zeitlich schneller dargestellt.");
        eintrag.setSelected(this.eigenschaften.aktiv("Kurzdarstellung"));
        eintrag.addActionListener(new Wechsel("Kurzdarstellung"));
        untermenue.addSeparator();
        ActionListener beobachter = ereignis -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl22 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl22 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.binarySort(TimSort.java:296)
             *     at java.base/java.util.TimSort.sort(TimSort.java:221)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        ButtonGroup gruppe = new ButtonGroup();
        eintrag = untermenue.add(new JRadioButtonMenuItem("\u00dcberlegungen einzeln best\u00e4tigen"));
        eintrag.setActionCommand("Einzeln");
        gruppe.add(eintrag);
        eintrag.setToolTipText("<html>\u00dcberlegungen zur W\u00fcrfelauswahl m\u00fcssen zus\u00e4tzlich einzeln best\u00e4tigt werden.</html>");
        eintrag.setSelected(this.eigenschaften.aktiv("Ueberlegungsbestaetigung") && !this.eigenschaften.aktiv("Geisterhand"));
        eintrag.addActionListener(beobachter);
        eintrag = untermenue.add(new JRadioButtonMenuItem("Aktionen gesammelt best\u00e4tigen"));
        eintrag.setActionCommand("Gesammelt");
        gruppe.add(eintrag);
        eintrag.setToolTipText("<html>Aktionen werden zusammengefasst best\u00e4tigt.</html>");
        eintrag.setSelected(!this.eigenschaften.aktiv("Ueberlegungsbestaetigung") && !this.eigenschaften.aktiv("Geisterhand"));
        eintrag.addActionListener(beobachter);
        eintrag = untermenue.add(new JRadioButtonMenuItem("Keinerlei Best\u00e4tigung erforderlich."));
        eintrag.setActionCommand("Geisterhand");
        gruppe.add(eintrag);
        eintrag.setToolTipText("<html><p>Bots spielen vollst\u00e4ndig autonom, ohne dass menschliche Mitspieler eingreifen m\u00fcssen oder k\u00f6nnen.</p><p><em>Achtung:</em> Der vorhergehende Spieler kann sein Setzen nicht r\u00fcckg\u00e4ngig machen.</p><html>");
        eintrag.setSelected(this.eigenschaften.aktiv("Geisterhand"));
        eintrag.addActionListener(beobachter);
        return untermenue;
    }

    private JMenu effekte() {
        JMenu untermenue = new JMenu("Effekte");
        untermenue.setToolTipText("Grafik- und Toneffekte");
        JMenuItem eintrag = untermenue.add(new JCheckBoxMenuItem("Eingangsgrafik"));
        eintrag.setToolTipText("Eingangsgrafik ein/ausschalten");
        eintrag.setSelected(this.eigenschaften.aktiv("Intro"));
        eintrag.addActionListener(new Wechsel(this, "Intro"){

            @Override
            public void actionPerformed(ActionEvent ereignis) {
                if (!betrieb) {
                    super.actionPerformed(ereignis);
                    if (this.aktiv()) {
                        this.firePropertyChange("Karte", "Text", "Intro");
                    } else {
                        this.firePropertyChange("Karte", "Intro", "Text");
                    }
                }
            }
        });
        eintrag = untermenue.add(new JCheckBoxMenuItem("Ger\u00e4usche"));
        eintrag.setEnabled(Ressource.soundsystem());
        eintrag.setToolTipText("Ger\u00e4usche ein/ausschalten");
        eintrag.setSelected(Ressource.soundsystem() && this.eigenschaften.aktiv("Geraeusche"));
        eintrag.addActionListener(new Wechsel("Geraeusche"));
        return untermenue;
    }

    private JMenuItem einfachklick() {
        JCheckBoxMenuItem eintrag = new JCheckBoxMenuItem("Setzen durch Einfachklick");
        eintrag.setToolTipText("<html>Wahl zwischen einmaligem und zweimaligem Klicken<br>zum Setzen des Wurfs in der Tabelle</html>");
        eintrag.setSelected(this.eigenschaften.aktiv("Einfachklick"));
        eintrag.addActionListener(new Wechsel("Einfachklick"));
        return eintrag;
    }

    private void erzeugeEinstellungenmenue() {
        JMenu menue = new JMenu("Einstellungen");
        menue.setMnemonic('E');
        menue.add(this.einfachklick());
        menue.add(this.botkontrolle());
        menue.addSeparator();
        menue.add(this.zwischenstand());
        menue.add(this.meldungen());
        menue.add(this.effekte());
        menue.add(this.lookandfeel());
        menue.addSeparator();
        menue.add(this.pfadwahl());
        menue.addSeparator();
        menue.add(this.versionsnachfrage());
        this.add(menue);
    }

    private void erzeugeExtrasmenue() {
        JMenu menue = new JMenu("Extras");
        menue.setMnemonic('X');
        this.add(menue);
        menue.add(this.rueckgaengig);
        this.rueckgaengig.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        this.rueckgaengig.setActionCommand("Rueckgaengig");
        this.rueckgaengig.setEnabled(false);
        this.rueckgaengig.setToolTipText("Letztes Setzen r\u00fcckg\u00e4ngig machen");
        menue.add(this.setzen);
        menue.addSeparator();
        JMenuItem eintrag = menue.add(new JMenuItem("Fenster anpassen"));
        eintrag.setAccelerator(KeyStroke.getKeyStroke(65, 0));
        eintrag.setToolTipText("Fenstergr\u00f6\u00dfe optimal anpassen an Tabelle, W\u00fcrfelfeld und Look & Feel");
        eintrag.addActionListener(ereignis -> SwingUtilities.invokeLater(() -> {
            Window umgebung = SwingUtilities.getWindowAncestor(this);
            umgebung.pack();
        }));
        menue.addSeparator();
        eintrag = menue.add(new JMenuItem("Neu zeichnen"));
        eintrag.setAccelerator(KeyStroke.getKeyStroke(78, 0));
        eintrag.setToolTipText("Alles neu zeichnen zur Beseitigung von Darstellungsfehlern");
        eintrag.addActionListener(ereignis -> SwingUtilities.getRootPane(this).repaint());
        eintrag = menue.add(new JMenuItem("Neustart"));
        if (this.eigenschaften.pfad() != null) {
            eintrag.addActionListener(event -> {
                this.eigenschaften.merkeNeustartAnforderung(this.betrieb);
                this.beenden.doClick();
            });
            eintrag.setToolTipText("<html><p>Neustart durchf\u00fchren mit automatischer Turnierfortsetzung.</p><p>Hilfreich weil Look & Feel-Wechsel nicht immer funktionieren.</p></html>");
        } else {
            eintrag.setEnabled(false);
            eintrag.setToolTipText(SANDBOX);
        }
    }

    private void erzeugeHilfemenue() {
        JMenu menue = new JMenu("Hilfe");
        menue.setMnemonic('H');
        this.add(menue);
        menue.add(this.vorschlagen);
        this.vorschlagen.addActionListener(ereignis -> this.setzen.setEnabled(true));
        menue.addSeparator();
        JMenuItem eintrag = menue.add(new JMenuItem("Hilfethemen"));
        eintrag.setAccelerator(KeyStroke.getKeyStroke(72, 0));
        eintrag.addActionListener(event -> {
            try {
                Hilfe hilfe = new Hilfe();
                hilfe.setLocationRelativeTo(SwingUtilities.getRootPane(this));
                hilfe.setVisible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Signal.WARNUNG.play();
                JOptionPane.showMessageDialog(SwingUtilities.getRootPane(this), "Hilfetexte k\u00f6nnen nicht angezeigt werden!\nFehlerhafte Installation? Keine Internetverbindung?\nJava-Exception: " + exception, "JaFuffy (Warnung)", 2);
            }
        });
        menue.addSeparator();
        eintrag = menue.add(new JMenuItem("<html>\u00dcber <i>JaFuffy</i></html>"));
        eintrag.addActionListener(ereignis -> {
            this.info.setLocationRelativeTo(SwingUtilities.getRootPane(this));
            this.info.setVisible(true);
        });
        eintrag = menue.add(new JMenuItem("Lizenzierung"));
        eintrag.addActionListener(ereignis -> {
            this.lizenzierung.setLocationRelativeTo(SwingUtilities.getRootPane(this));
            this.lizenzierung.setVisible(true);
        });
        menue.addSeparator();
        eintrag = menue.add(new JMenuItem("Aktualisieren..."));
        eintrag.setToolTipText("<html>Sucht auf der <i>JaFuffy</i>-Homepage nach neuerer Version<html>");
        eintrag.addActionListener(ereignis -> this.update.ueberpruefe(SwingUtilities.getRootPane(this)));
    }

    private void erzeugeStatistikmenue() {
        JMenu menue = new JMenu("Statistik");
        menue.setMnemonic('S');
        this.add(menue);
        menue.add(this.berichten);
        this.berichten.setToolTipText("(Zischen)Stand & Turnierverlauf");
        this.berichten.setEnabled(false);
        this.berichten.addActionListener(ereignis -> {
            this.report.setLocationRelativeTo(SwingUtilities.getRootPane(this));
            this.report.setVisible(true);
        });
        JMenuItem eintrag = menue.add(new JMenuItem("Bestenliste"));
        eintrag.addActionListener(ereignis -> {
            this.bestenliste.setLocationRelativeTo(SwingUtilities.getRootPane(this));
            this.bestenliste.setVisible(true);
        });
    }

    private void erzeugeTurniermenue() {
        JMenu menue = new JMenu("Turnier");
        menue.setMnemonic('T');
        this.add(menue);
        JMenuItem eintrag = menue.add(new JMenuItem("Beginnen..."));
        eintrag.setAccelerator(KeyStroke.getKeyStroke(66, 0));
        eintrag.addActionListener(ereignis -> this.firePropertyChange("Beginnen", null, this));
        menue.addSeparator();
        menue.add(this.speichern);
        this.speichern.setEnabled(false);
        this.speichern.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        if (this.fortsetzung != null) {
            this.speichern.addActionListener(ereignis -> {
                this.fortsetzung.setLocationRelativeTo(SwingUtilities.getRootPane(this));
                this.fortsetzung.speichere();
            });
        } else {
            this.speichern.setToolTipText(SANDBOX);
        }
        menue.add(this.speichernUnter);
        this.speichernUnter.setEnabled(false);
        if (this.fortsetzung != null) {
            this.speichernUnter.addActionListener(ereignis -> {
                this.fortsetzung.setLocationRelativeTo(SwingUtilities.getRootPane(this));
                this.fortsetzung.speichereUnter();
                this.fortsetzung.setVisible(true);
            });
        } else {
            this.speichernUnter.setToolTipText(SANDBOX);
        }
        eintrag = menue.add(new JMenuItem("Fortsetzen..."));
        if (this.fortsetzung != null) {
            eintrag.addActionListener(ereignis -> {
                this.fortsetzung.setLocationRelativeTo(SwingUtilities.getRootPane(this));
                this.fortsetzung.setzeFort();
                this.fortsetzung.setVisible(true);
            });
        } else {
            eintrag.setEnabled(false);
            eintrag.setToolTipText(SANDBOX);
        }
        menue.addSeparator();
        menue.add(this.beenden);
        this.beenden.addActionListener(ereignis -> {
            Window umgebung = SwingUtilities.getWindowAncestor(this);
            WindowEvent fensterereignis = new WindowEvent(umgebung, 201);
            umgebung.dispatchEvent(fensterereignis);
        });
    }

    private List<UIManager.LookAndFeelInfo> lafs() {
        List<UIManager.LookAndFeelInfo> lafs = Arrays.asList(UIManager.getInstalledLookAndFeels());
        Collections.sort(lafs, (laf1, laf2) -> laf1.getName().compareToIgnoreCase(laf2.getName()));
        return lafs;
    }

    private JMenu lookandfeel() {
        JMenu untermenue = new JMenu("Look and Feel");
        untermenue.setToolTipText("<html><p>Look & Feel der Benutzeroberfl\u00e4che.</p><p>Je nach Auswahl kann ein Neustart erforderlich sein, siehe Extras-Men\u00fc.</p></html>");
        ButtonGroup gruppe = new ButtonGroup();
        for (UIManager.LookAndFeelInfo laf : this.lafs()) {
            JRadioButtonMenuItem eintrag = new JRadioButtonMenuItem(laf.getName());
            String alt = this.eigenschaften.getProperty("LookAndFeel");
            eintrag.setSelected(alt.equals(laf.getClassName()));
            eintrag.addActionListener(event -> {
                String alt1 = this.eigenschaften.getProperty("LookAndFeel");
                String neu = laf.getClassName();
                this.firePropertyChange("LookAndFeel", alt1, neu);
            });
            untermenue.add(eintrag);
            gruppe.add(eintrag);
        }
        return untermenue;
    }

    private void meldeTurnierAb(Turnier turnier) {
        this.betrieb = false;
        this.aktualisiere(false, false, false);
        this.speichern.setEnabled(false);
        this.speichernUnter.setEnabled(false);
        this.vorschlagen.removeActionListener(turnier);
        this.rueckgaengig.removeActionListener(turnier);
    }

    private void meldeTurnierAn(Turnier turnier) {
        this.betrieb = true;
        this.aktualisiere(turnier.vorschlagbar(), false, false);
        this.vorschlagen.addActionListener(turnier);
        this.rueckgaengig.addActionListener(turnier);
        this.speichern.setEnabled(false);
        this.speichernUnter.setEnabled(this.fortsetzung != null && !this.netzwerk);
        this.berichten.setEnabled(true);
    }

    private JMenu meldungen() {
        JMenu untermenue = new JMenu("Meldungen");
        untermenue.setToolTipText("Meldungen ein/ausschalten bei...");
        JMenuItem eintrag = untermenue.add(new JCheckBoxMenuItem("Hinweise"));
        eintrag.setToolTipText("Allgemeine Hinweise (\"ToolTips\" in K\u00e4sten) anzeigen?");
        eintrag.setSelected(this.eigenschaften.aktiv("Hinweis"));
        ToolTipManager.sharedInstance().setEnabled(this.eigenschaften.aktiv("Hinweis"));
        eintrag.addActionListener(new Wechsel(this, "Hinweis"){

            @Override
            public void actionPerformed(ActionEvent ereignis) {
                super.actionPerformed(ereignis);
                ToolTipManager.sharedInstance().setEnabled(this.aktiv());
            }
        });
        eintrag = untermenue.add(new JCheckBoxMenuItem("Spicker"));
        eintrag.setToolTipText("Spicker f\u00fcr W\u00fcrfelpunkte in Tabelle?");
        eintrag.setSelected(this.eigenschaften.aktiv("Spicker"));
        eintrag.addActionListener(new Wechsel("Spicker"));
        eintrag = untermenue.add(new JCheckBoxMenuItem("Erinnerung abgebrochenes Turnier"));
        if (this.fortsetzung != null) {
            eintrag.setToolTipText("Erinnerung an abgebrochenes Turnier zum Weiterspielen?");
            eintrag.setSelected(this.eigenschaften.aktiv("Erinnerung"));
            eintrag.addActionListener(new Wechsel("Erinnerung"));
        } else {
            eintrag.setEnabled(false);
            eintrag.setToolTipText(SANDBOX);
        }
        return untermenue;
    }

    private JMenuItem pfadwahl() {
        JMenuItem eintrag = new JMenuItem("Pfad...");
        if (this.eigenschaften.pfad() != null) {
            eintrag.setToolTipText("<html><p>Pfad zu Statistikdaten und Turnierst\u00e4nden einstellen.</p><p>Aktuelle Einstellung: <strong>" + this.eigenschaften.pfad() + "</strong></p>" + "</html>");
            eintrag.addActionListener(ereignis -> {
                Pfad pfad = new Pfad(this.eigenschaften, SwingUtilities.getRootPane(this));
            });
        } else {
            eintrag.setEnabled(false);
            eintrag.setToolTipText(SANDBOX);
        }
        return eintrag;
    }

    private JMenuItem versionsnachfrage() {
        JCheckBoxMenuItem eintrag = new JCheckBoxMenuItem("Nach neuerer Version schauen");
        if (this.eigenschaften.pfad() != null) {
            eintrag.setToolTipText("<html>Bei jedem Programmstart automatisch nach neuerer Version auf <i>JaFuffy</i>-Homepage suchen<html>");
            eintrag.setSelected(this.eigenschaften.aktiv("Nachschauen"));
            eintrag.addActionListener(new Wechsel("Nachschauen"));
        } else {
            eintrag.setEnabled(false);
            eintrag.setToolTipText(SANDBOX);
        }
        return eintrag;
    }

    private JMenuItem zwischenstand() {
        JCheckBoxMenuItem eintrag = new JCheckBoxMenuItem("Zwischenstandsanzeige");
        eintrag.setAccelerator(KeyStroke.getKeyStroke(90, 0));
        eintrag.setToolTipText("<html>Die Punktezahl des derzeitigen Wurfs<br>f\u00fcr jeden freien Tabellenplatz anzeigen?</html>");
        eintrag.setSelected(this.eigenschaften.aktiv("Zwischenstand"));
        eintrag.addActionListener(new Wechsel("Zwischenstand"));
        eintrag.addActionListener(ereignis -> SwingUtilities.getRootPane(this).repaint());
        return eintrag;
    }

    private class Wechsel
    implements ActionListener {
        private final String schluessel;

        Wechsel(String schluessel) {
            this.schluessel = schluessel;
        }

        @Override
        public void actionPerformed(ActionEvent ereignis) {
            Menue.this.eigenschaften.wechsle(this.schluessel);
        }

        boolean aktiv() {
            return Menue.this.eigenschaften.aktiv(this.schluessel);
        }
    }
}

