/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Grafik;
import jafuffy.logik.Spieler;
import jafuffy.logik.Statistik;
import jafuffy.logik.Turnier;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class Verfolgung
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    private static final Color SCHRITTBESCHREIBUNGSFARBE = new Color(240, 255, 255);
    private static final Color LINIENFARBE = new Color(48, 128, 192);
    private static final int ABSTAND = 4;
    private static final float BOTFELDGEWICHT = 0.4f;
    private static final int BOTFELDBREITE = 125;
    private static final String MENSCHKARTE = "Mensch";
    private static final String BOTKARTE = "Bot";
    private static final String RANGKARTE = "Rangliste";
    private static final ImageIcon WUERFELN = Grafik.icon("Wuerfeln.gif");
    private static final ImageIcon WUERFELN0 = Grafik.icon("Wuerfeln0.gif");
    private static final ImageIcon EINTRAG = Grafik.icon("Eintrag.gif");
    private static final ImageIcon FERTIG = Grafik.icon("Fertig.gif");
    private static final ImageIcon BOT = Grafik.icon("Bot.png");
    private static final Dimension ZELLABSTAND = new Dimension(5, 1);
    private final JLabel mensch = new JLabel(WUERFELN0);
    private final JLabel bot = new JLabel(BOT);
    private final JTextArea botschritt = new JTextArea(2, 5);
    private final JButton naechsteAktion = this.weiter(34);
    private final JButton alleAktionen = this.weiter(35);
    private final JTable rangtabelle;

    public Verfolgung(Statistik statistik) {
        super(new CardLayout());
        this.rangtabelle = new JTable(new Rangmodell(statistik));
        this.add((Component)this.menschkarte(), MENSCHKARTE);
        this.add((Component)this.botkarte(), BOTKARTE);
        this.add((Component)this.rangkarte(), RANGKARTE);
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        this.mensch.addMouseListener(listener);
    }

    public void erledigeNaechsteAktion(int dauer) {
        this.naechsteAktion.doClick(dauer);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        Object wert = event.getNewValue();
        if (name.equals("LongDescription")) {
            this.botschritt.setText((String)wert);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (Umschlag.adressiert(ce, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(ce);
            Ablauf ereignis = (Ablauf)((Object)umschlag.ereignis());
            switch (ereignis) {
                case START: {
                    this.starte();
                }
                case SPIEL: 
                case GEWORFEN: 
                case FERTIG: 
                case RUECKGAENGIG: {
                    this.aktualisiere((Turnier)umschlag.quelle());
                    break;
                }
                case RESULTAT: {
                    this.verstecke();
                    break;
                }
                case ENDE: {
                    this.beschliesse();
                }
                case ABBRUCH: {
                    this.beende();
                    break;
                }
            }
        }
    }

    public void verknuepfe(Action aktion, String anzeige, String hilfe) {
        aktion.addPropertyChangeListener(this);
        aktion.putValue("Name", anzeige);
        aktion.putValue("ShortDescription", hilfe);
        if (anzeige.equals("Anstehende Aktion")) {
            this.naechsteAktion.setAction(aktion);
        }
        if (anzeige.equals("Alle Aktionen")) {
            this.alleAktionen.setAction(aktion);
        }
    }

    private void aktualisiere(Turnier turnier) {
        Spieler aktiver = turnier.aktiver();
        CardLayout layout = (CardLayout)this.getLayout();
        boolean neu = aktiver.neu();
        boolean fertig = aktiver.fertig();
        if (aktiver.real()) {
            layout.show(this, MENSCHKARTE);
        } else {
            this.requestFocusInWindow();
            layout.show(this, BOTKARTE);
        }
        this.mensch.setEnabled(!neu);
        this.mensch.setIcon(fertig ? EINTRAG : WUERFELN0);
        this.bot.setEnabled(true);
    }

    private void beende() {
        this.mensch.setDisabledIcon(FERTIG);
        this.mensch.setEnabled(false);
        this.bot.setEnabled(false);
    }

    private void beschliesse() {
        this.mensch.setIcon(FERTIG);
        ((TableRowSorter)this.rangtabelle.getRowSorter()).sort();
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show(this, RANGKARTE);
    }

    private JPanel botfeld(String titel, String hilfe) {
        JPanel feld = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(125, super.getPreferredSize().height);
            }
        };
        feld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, titel, 2, 2, null, Color.BLUE), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        feld.setToolTipText(hilfe);
        return feld;
    }

    private JPanel botkarte() {
        this.botschritt.setLineWrap(true);
        this.botschritt.setWrapStyleWord(true);
        this.botschritt.setEditable(false);
        this.botschritt.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(LINIENFARBE), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.botschritt.setBackground(SCHRITTBESCHREIBUNGSFARBE);
        this.bot.setBorder(BorderFactory.createEtchedBorder());
        this.bot.setEnabled(false);
        GridBagConstraints c = new GridBagConstraints();
        JPanel aktion = this.botfeld("Anstehende Aktion", "Beschreibung der Aktion, welche der Bot als n\u00e4chstes ausf\u00fchren m\u00f6chte.");
        aktion.setLayout(new GridBagLayout());
        c.fill = 2;
        c.gridx = 0;
        c.weightx = 1.0;
        aktion.add((Component)this.botschritt, c);
        JPanel bestaetigung = this.botfeld("Best\u00e4tigung", "Anstehende Bot-Aktion zur Kenntnis genommen, Best\u00e4tigung zum Weitermachen");
        bestaetigung.setLayout(new GridLayout(2, 1, 0, 4));
        bestaetigung.add(this.alleAktionen);
        bestaetigung.add(this.naechsteAktion);
        JPanel feld = new JPanel();
        feld.setLayout(new GridBagLayout());
        c.fill = 1;
        c.gridx = 0;
        c.weightx = 0.4f;
        c.weighty = 1.0;
        feld.add((Component)aktion, c);
        c.fill = 0;
        c.gridx = 1;
        c.weightx = 0.19999998807907104;
        feld.add((Component)this.bot, c);
        c.fill = 1;
        c.gridx = 2;
        c.weightx = 0.4f;
        feld.add((Component)bestaetigung, c);
        return feld;
    }

    private JPanel menschkarte() {
        this.mensch.setToolTipText("Sortieren durch Doppelklick, Kontextmen\u00fc");
        this.mensch.setBorder(BorderFactory.createEtchedBorder());
        this.mensch.setAlignmentX(0.5f);
        this.mensch.setEnabled(false);
        JPanel feld = new JPanel();
        feld.setLayout(new BoxLayout(feld, 3));
        feld.add(Box.createVerticalGlue());
        feld.add(this.mensch);
        feld.add(Box.createVerticalGlue());
        return feld;
    }

    private JPanel rangkarte() {
        JPanel rangkarte = new JPanel();
        rangkarte.setLayout(new BoxLayout(rangkarte, 2));
        this.rangtabelle.setRowSelectionAllowed(false);
        this.rangtabelle.setColumnSelectionAllowed(false);
        this.rangtabelle.setCellSelectionEnabled(false);
        this.rangtabelle.setFocusable(false);
        this.rangtabelle.setEnabled(false);
        this.rangtabelle.setIntercellSpacing(ZELLABSTAND);
        this.rangtabelle.setRowHeight(this.rangtabelle.getRowHeight() + Verfolgung.ZELLABSTAND.height);
        DefaultTableCellRenderer punktezeichner = new DefaultTableCellRenderer();
        punktezeichner.setHorizontalAlignment(4);
        this.rangtabelle.getColumnModel().getColumn(Rangmodell.SPALTEN.PUNKTE.ordinal()).setCellRenderer(punktezeichner);
        this.rangtabelle.setAutoCreateRowSorter(true);
        TableRowSorter<TableModel> sortierer = new TableRowSorter<TableModel>(this.rangtabelle.getModel()){

            @Override
            public boolean isSortable(int column) {
                return column != Rangmodell.SPALTEN.NAME.ordinal();
            }
        };
        this.rangtabelle.setRowSorter((RowSorter<? extends TableModel>)sortierer);
        ArrayList<RowSorter.SortKey> sortierschluessel = new ArrayList<RowSorter.SortKey>();
        sortierschluessel.add(new RowSorter.SortKey(Rangmodell.SPALTEN.SIEGE.ordinal(), SortOrder.DESCENDING));
        sortierer.setSortKeys(sortierschluessel);
        final JTableHeader tabellenkopf = this.rangtabelle.getTableHeader();
        tabellenkopf.setDefaultRenderer(new Kopfzeichner(this.rangtabelle));
        tabellenkopf.setReorderingAllowed(false);
        tabellenkopf.setFocusable(false);
        int spaltenindex = 0;
        while (spaltenindex < Rangmodell.RANGLISTENKOPF.length) {
            String spaltentitel = Rangmodell.RANGLISTENKOPF[spaltenindex];
            TableColumn spalte = tabellenkopf.getColumnModel().getColumn(spaltenindex);
            spalte.setHeaderValue(spaltentitel);
            Component zeichner = this.rangtabelle.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(this.rangtabelle, spaltentitel, false, false, 0, spaltenindex);
            spalte.setPreferredWidth(zeichner.getFontMetrics(zeichner.getFont()).stringWidth(spaltentitel) + 2 * Verfolgung.ZELLABSTAND.width);
            ++spaltenindex;
        }
        tabellenkopf.setToolTipText("Das Turnierergebnis, sortierbar nach Siegen oder Endst\u00e4nden.");
        JScrollPane scrollfeld = new JScrollPane(this.rangtabelle, 21, 31){

            @Override
            public Dimension getPreferredSize() {
                Dimension kopf = tabellenkopf.getPreferredSize();
                Dimension koerper = Verfolgung.this.rangtabelle.getPreferredSize();
                return new Dimension(kopf.width, kopf.height + koerper.height);
            }
        };
        JPanel hilfsfeld = new JPanel();
        hilfsfeld.setLayout(new BoxLayout(hilfsfeld, 3));
        hilfsfeld.add(Box.createVerticalGlue());
        hilfsfeld.add(Box.createVerticalGlue());
        hilfsfeld.add(scrollfeld);
        hilfsfeld.add(Box.createVerticalGlue());
        JLabel links = new JLabel(FERTIG);
        links.setBorder(BorderFactory.createEtchedBorder());
        JLabel rechts = new JLabel(FERTIG);
        rechts.setBorder(BorderFactory.createEtchedBorder());
        rangkarte.add(Box.createHorizontalGlue());
        rangkarte.add(links);
        rangkarte.add(Box.createHorizontalGlue());
        rangkarte.add(hilfsfeld);
        rangkarte.add(Box.createHorizontalGlue());
        rangkarte.add(rechts);
        rangkarte.add(Box.createHorizontalGlue());
        return rangkarte;
    }

    private void starte() {
        this.mensch.setDisabledIcon(WUERFELN);
    }

    private void verstecke() {
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show(this, MENSCHKARTE);
    }

    private JButton weiter(int taste) {
        JButton weiter = new JButton();
        weiter.setMargin(new Insets(2, 0, 2, 0));
        weiter.getInputMap(2).put(KeyStroke.getKeyStroke(taste, 0), weiter);
        weiter.getActionMap().put(weiter, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JButton weiter = (JButton)event.getSource();
                weiter.doClick();
            }
        });
        return weiter;
    }

    private static class Kopfzeichner
    implements TableCellRenderer {
        private final DefaultTableCellRenderer zeichner;

        Kopfzeichner(JTable rangliste) {
            this.zeichner = (DefaultTableCellRenderer)rangliste.getTableHeader().getDefaultRenderer();
            this.zeichner.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DefaultTableCellRenderer korrektor = (DefaultTableCellRenderer)this.zeichner.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (korrektor.getBorder() == null) {
                korrektor.setBorder(BorderFactory.createEtchedBorder());
            }
            return korrektor;
        }
    }

    private static class Rangmodell
    extends AbstractTableModel {
        private static final String[] RANGLISTENKOPF = new String[]{"Teilnehmer", "Siege", "Stand"};
        private final Statistik statistik;

        Rangmodell(Statistik statistik) {
            this.statistik = statistik;
        }

        @Override
        public int getColumnCount() {
            return RANGLISTENKOPF.length;
        }

        @Override
        public String getColumnName(int spaltenindex) {
            return RANGLISTENKOPF[spaltenindex];
        }

        @Override
        public int getRowCount() {
            return this.statistik == null || this.statistik.teilnehmer() == null ? 0 : this.statistik.teilnehmer().size();
        }

        @Override
        public Object getValueAt(int teilnehmerindex, int spaltenindex) {
            if (spaltenindex == SPALTEN.NAME.ordinal()) {
                return this.statistik.teilnehmer().get(teilnehmerindex).anzeigename();
            }
            if (spaltenindex == SPALTEN.PUNKTE.ordinal()) {
                return this.statistik.stand(this.statistik.teilnehmer().get(teilnehmerindex));
            }
            if (spaltenindex == SPALTEN.SIEGE.ordinal()) {
                return this.statistik.siege(teilnehmerindex);
            }
            return null;
        }

        private static enum SPALTEN {
            NAME,
            SIEGE,
            PUNKTE;

        }
    }
}

