/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Wuerfelreihe;
import jafuffy.logik.Turnier;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Wechselfeld
extends JPanel
implements ChangeListener {
    private static final int WUERFELRAHMENABSTAND = 4;
    private static final String VERSTECK = "Versteck";
    private static final String ANZEIGE = "Anzeige";

    Wechselfeld(Wuerfelreihe reihe) {
        super(new CardLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "W\u00fcrfelauswahl", 2, 2), BorderFactory.createEmptyBorder(0, 2, 4, 2)));
        this.add((Component)new JPanel(), VERSTECK);
        this.add((Component)reihe, ANZEIGE);
        this.setToolTipText("Sortieren durch Doppelklick auf freie Fl\u00e4che, Kontextmen\u00fc");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (Umschlag.adressiert(ce, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(ce);
            switch ((Ablauf)((Object)umschlag.ereignis())) {
                case START: 
                case SPIEL: 
                case GEWORFEN: 
                case FERTIG: 
                case RUECKGAENGIG: {
                    this.aktualisiere((Turnier)umschlag.quelle());
                    break;
                }
                case RESULTAT: {
                    this.verstecke();
                    break;
                }
                case ABBRUCH: {
                    this.verstecke();
                }
                case ENDE: {
                    this.setEnabled(false);
                    break;
                }
            }
        }
    }

    private void aktualisiere(Turnier turnier) {
        boolean neu = turnier.aktiver().neu();
        boolean interaktiv = turnier.aktiver().real();
        this.setEnabled(!neu && interaktiv);
        ((CardLayout)this.getLayout()).show(this, neu ? VERSTECK : ANZEIGE);
    }

    private void verstecke() {
        ((CardLayout)this.getLayout()).show(this, VERSTECK);
    }
}

