/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Absprache;
import jafuffy.bedienung.Becher;
import jafuffy.bedienung.Bestenliste;
import jafuffy.bedienung.Ende;
import jafuffy.bedienung.Fenster;
import jafuffy.bedienung.Fortsetzung;
import jafuffy.bedienung.Kommentierung;
import jafuffy.bedienung.Menue;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.Report;
import jafuffy.bedienung.Setzen;
import jafuffy.bedienung.Spielplatz;
import jafuffy.bedienung.Verfolgung;
import jafuffy.bedienung.Vorschlagen;
import jafuffy.logik.Aufsicht;
import jafuffy.logik.Name;
import jafuffy.logik.Plan;
import jafuffy.logik.Spieler;
import jafuffy.logik.Statistik;
import jafuffy.logik.Turnier;
import jafuffy.logik.Update;
import jafuffy.netzwerk.Vermittlung;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class Manager {
    private final Eigenschaften eigenschaften;
    private final Absprache absprache;
    private final Ende ende;
    private final Fenster fenster;
    private final Fortsetzung fortsetzung;
    private final Menue menue;
    private final Spielplatz spielplatz;
    private final Aufsicht aufsicht;
    private final Statistik statistik;
    private Turnier turnier;
    private int vorgaengerspielerzahl;

    public Manager(Eigenschaften eigenschaften, Statistik statistik, Fenster fenster, Ende ende, Update update) {
        this.eigenschaften = eigenschaften;
        this.statistik = statistik;
        this.fenster = fenster;
        this.ende = ende;
        this.vorgaengerspielerzahl = 0;
        int i = 0;
        while (i < 4) {
            if (!eigenschaften.getProperty("Name" + i).equals("")) {
                ++this.vorgaengerspielerzahl;
            }
            ++i;
        }
        this.absprache = new Absprache(eigenschaften, fenster, this);
        this.fortsetzung = eigenschaften.pfad() != null ? new Fortsetzung(eigenschaften, fenster) : null;
        Becher becher = new Becher();
        Verfolgung verfolgung = new Verfolgung(statistik);
        Setzen setzen = new Setzen();
        Vorschlagen vorschlagen = new Vorschlagen();
        Report report = new Report(statistik);
        Bestenliste bestenliste = new Bestenliste(statistik, eigenschaften.variante());
        this.spielplatz = new Spielplatz(eigenschaften, becher, verfolgung, setzen);
        this.aufsicht = new Aufsicht(eigenschaften, fenster, vorschlagen, becher, verfolgung, setzen);
        this.menue = new Menue(eigenschaften, vorschlagen, setzen, report, bestenliste, this.fortsetzung, update);
        this.spielplatz.addPropertyChangeListener("Beginnen", this.absprache);
        this.menue.addPropertyChangeListener("LookAndFeel", new Oberflaeche(eigenschaften));
        this.menue.addPropertyChangeListener("Beginnen", this.absprache);
        this.menue.addPropertyChangeListener("Karte", this.spielplatz);
        statistik.addChangeListener(bestenliste);
        statistik.addChangeListener(report);
        statistik.addChangeListener(new Kommentierung(this.spielplatz));
        fenster.zeige(eigenschaften, this.menue, this.spielplatz);
        if (this.fortsetzung != null) {
            this.fortsetzung.addPropertyChangeListener("Speichern", this.menue);
            this.fortsetzung.verbinde(this);
            this.fortsetzung.versuche();
        }
    }

    public void betreibe(Plan plan) {
        this.betreibe(new Turnier(this.teilnehmer(this.eigenschaften, plan.namen), plan.beginner, plan.variante, plan.maximalanzahl, plan.erster), null);
    }

    public void betreibe(Plan plan, Vermittlung vermittlung) {
        Turnier kandidat = new Turnier(this.teilnehmer(this.eigenschaften, plan.namen), plan.beginner, plan.variante, plan.maximalanzahl, plan.erster);
        this.menue.propertyChange(new PropertyChangeEvent(this, "Netzwerk", false, true));
        vermittlung.verknuepfe(kandidat.wuerfelsatz(), kandidat);
        kandidat.addChangeListener(vermittlung);
        this.betreibe(kandidat, vermittlung);
    }

    public void betreibe(Turnier kandidat) {
        this.betreibe(kandidat, null);
    }

    public Vermittlung vermittlung(Vermittlung.Eroeffnung eroeffnung) {
        return new Vermittlung(eroeffnung, this.aufsicht);
    }

    private void betreibe(Turnier kandidat, Vermittlung vermittlung) {
        if (this.turnier != null) {
            this.vorgaengerspielerzahl = this.turnier.teilnehmer().size();
            this.turnier.beende();
        }
        this.turnier = kandidat;
        this.turnier.setzeFort(this.statistik);
        this.turnier.addChangeListener(this.spielplatz);
        this.turnier.addChangeListener(this.menue);
        this.turnier.addChangeListener(this.ende);
        this.turnier.auswertung().addChangeListener(this.spielplatz);
        int w = 0;
        while (w < 5) {
            this.turnier.wuerfel(w).addChangeListener(this.spielplatz);
            this.turnier.wuerfel(w).addChangeListener(this.aufsicht.wuerfelbeobachter(w));
            ++w;
        }
        this.turnier.addChangeListener(this.fortsetzung);
        this.turnier.addChangeListener(this.aufsicht);
        if (this.fenster != null) {
            this.fenster.setTitle("JaFuffy (" + this.turnier.auswertung() + ", " + (Object)((Object)this.turnier.beginner()) + ")");
            if (this.vorgaengerspielerzahl != this.turnier.teilnehmer().size()) {
                SwingUtilities.invokeLater(() -> this.fenster.pack());
            }
        }
        this.aufsicht.verknuepfe(vermittlung);
        this.turnier.starte();
    }

    ArrayList<Spieler> teilnehmer(Eigenschaften eigenschaften, ArrayList<Name> namen) {
        ArrayList<Spieler> teilnehmer = new ArrayList<Spieler>(4);
        for (Name name : namen) {
            try {
                teilnehmer.add(name.spieler(eigenschaften));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ausnahme) {
                ausnahme.printStackTrace();
                throw new RuntimeException("Programmierfehler: Unbekannter Spielertyp.");
            }
        }
        return teilnehmer;
    }
}

