/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.Bestenlistenmodell;
import jafuffy.logik.Spieler;
import jafuffy.logik.Variante;
import jafuffy.logik.ereignis.Aenderungen;
import jafuffy.logik.ereignis.Aktualisierung;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Locale;

public class Statistik
extends Aenderungen<Aktualisierung>
implements Serializable {
    private static final long serialVersionUID = -4577948675428850797L;
    public static final String STAT = "Statistik.obj";
    private static final int MAXRAENGE = 12;
    private transient Variante variante;
    private transient ArrayList<Spieler> teilnehmer;
    private transient ArrayList<Rang> raenge;
    private transient int maximalanzahl;
    private transient int mittelwert;
    private transient int abweichung;
    private transient ArrayList<Integer> ruecknahmen;
    private transient ArrayList<Integer> spielstaende;
    private transient ArrayList<Integer> turnierstaende;
    private transient ArrayList<Integer> siege;
    private transient ArrayList<ArrayList<Integer>> verlaeufe;
    private transient int spielindex;
    private transient HashMap<Variante, Bestenlistenmodell> bestenlistenmodelle;
    private final HashMap<Variante, ArrayList<Rang>> ranglisten = new HashMap(Variante.ANZAHL);
    private final HashMap<Variante, Integer> ns = new HashMap(Variante.ANZAHL);
    private final HashMap<Variante, Integer> summen = new HashMap(Variante.ANZAHL);
    private final HashMap<Variante, Long> quadratsummen = new HashMap(Variante.ANZAHL);

    public Statistik() {
        Variante[] varianteArray = Variante.values();
        int n = varianteArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variante variante = varianteArray[n2];
            this.ns.put(variante, 0);
            this.summen.put(variante, 0);
            this.quadratsummen.put(variante, 0L);
            this.ranglisten.put(variante, new ArrayList(12));
            ++n2;
        }
        this.erzeugeBestenlistenmodelle();
    }

    public int abweichung() {
        return this.abweichung;
    }

    public HashMap<Variante, Bestenlistenmodell> bestenlistenmodelle() {
        return this.bestenlistenmodelle;
    }

    public double durchschnitt(Variante variante) {
        return (double)this.summen.get((Object)variante).intValue() / (double)this.ns.get((Object)variante).intValue();
    }

    public int maximalanzahl() {
        return this.maximalanzahl;
    }

    public int mittelwert() {
        return this.mittelwert;
    }

    public int n(Variante variante) {
        return this.ns.get((Object)variante);
    }

    public ArrayList<Rang> raenge() {
        return this.raenge;
    }

    public int rest() {
        return this.maximalanzahl == 0 ? 1 : this.maximalanzahl - this.spielindex;
    }

    public int siege(int teilnehmerindex) {
        return this.siege.get(teilnehmerindex);
    }

    public int spielanzahl() {
        if (this.rest() > 0) {
            return this.spielindex + 1;
        }
        return this.maximalanzahl;
    }

    public int stand(Spieler spieler) {
        return this.turnierstaende.get(spieler.index()) + this.spielstaende.get(spieler.index());
    }

    public double standardabweichung(Variante variante) {
        double quadratsumme = this.quadratsummen.get((Object)variante).longValue();
        double summe = this.summen.get((Object)variante).intValue();
        int n = this.ns.get((Object)variante);
        return Math.sqrt((quadratsumme - summe * summe / (double)n) / (double)(n - 1));
    }

    public ArrayList<Spieler> teilnehmer() {
        return this.teilnehmer;
    }

    public String titel() {
        if (this.maximalanzahl == 0) {
            return String.valueOf(this.spielanzahl()) + ". Spiel im Turnier";
        }
        if (this.rest() > 0) {
            if (this.maximalanzahl == 1) {
                return "Einziges Spiel im Turnier";
            }
            return String.valueOf(this.spielanzahl()) + ". von " + this.maximalanzahl + " Spielen im Turnier";
        }
        return "Turnierende";
    }

    public Variante variante() {
        return this.variante;
    }

    public ArrayList<ArrayList<Integer>> verlaeufe() {
        return this.verlaeufe;
    }

    private void aktualisiere() {
        for (Spieler spieler : this.teilnehmer) {
            int ergebnis = spieler.endsumme();
            this.summen.put(this.variante, this.summen.get((Object)this.variante) + ergebnis);
            this.quadratsummen.put(this.variante, this.quadratsummen.get((Object)this.variante) + (long)(ergebnis * ergebnis));
        }
        this.ns.put(this.variante, this.ns.get((Object)this.variante) + this.teilnehmer.size());
    }

    private void einordne() {
        boolean aktualisieren = false;
        this.raenge = new ArrayList(this.teilnehmer.size());
        for (Spieler spieler : this.teilnehmer) {
            int j = 0;
            ListIterator<Rang> rangiterator = this.ranglisten.get((Object)this.variante).listIterator();
            Rang rang = null;
            boolean eingeordnet = false;
            while (rangiterator.hasNext() && !eingeordnet) {
                j = rangiterator.nextIndex();
                rang = rangiterator.next();
                boolean bl = eingeordnet = rang.punkte <= spieler.endsumme();
            }
            if (eingeordnet && rang.punkte < spieler.endsumme()) {
                if (this.ranglisten.get((Object)this.variante).size() == 12) {
                    this.raenge.remove(this.ranglisten.get((Object)this.variante).get(11));
                    this.ranglisten.get((Object)this.variante).remove(11);
                }
                rang = new Rang();
                this.ranglisten.get((Object)this.variante).add(j, rang);
            }
            if (!eingeordnet && this.ranglisten.get((Object)this.variante).size() < 12) {
                rang = new Rang();
                this.ranglisten.get((Object)this.variante).add(rang);
                eingeordnet = true;
            }
            if (!eingeordnet) continue;
            aktualisieren = true;
            rang.notiere(spieler);
            this.raenge.add(rang);
        }
        if (aktualisieren) {
            int rangnummer = 1;
            for (Rang rangliste : this.ranglisten.get((Object)this.variante)) {
                rangliste.platziere(rangnummer);
                rangnummer += rangliste.eintraege.size();
            }
            this.fireStateChanged(Aktualisierung.BESTER);
        }
    }

    private void eroeffne() {
        ++this.spielindex;
        if (this.rest() > 0) {
            for (Spieler spieler : this.teilnehmer) {
                this.verlaeufe.get(spieler.index()).add(0);
            }
        }
    }

    private void erzeugeBestenlistenmodelle() {
        this.bestenlistenmodelle = new HashMap(Variante.ANZAHL);
        Variante[] varianteArray = Variante.values();
        int n = varianteArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variante variante = varianteArray[n2];
            this.bestenlistenmodelle.put(variante, new Bestenlistenmodell(this.ranglisten.get((Object)variante)));
            ++n2;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.erzeugeBestenlistenmodelle();
    }

    private void schliesse() {
        int max = 0;
        for (Spieler spieler : this.teilnehmer) {
            this.turnierstaende.set(spieler.index(), this.turnierstaende.get(spieler.index()) + spieler.endsumme());
            max = Math.max(this.spielstaende.get(spieler.index()), max);
            this.spielstaende.set(spieler.index(), 0);
        }
        for (Spieler spieler : this.teilnehmer) {
            if (spieler.endsumme() != max) continue;
            this.siege.set(spieler.index(), this.siege.get(spieler.index()) + 1);
        }
    }

    void annulliere() {
        for (Spieler spieler : this.teilnehmer) {
            this.spielstaende.set(spieler.index(), this.ruecknahmen.get(spieler.index()));
            this.verlaeufe.get(spieler.index()).set(this.spielindex, this.spielstaende.get(spieler.index()));
        }
        this.fireStateChanged(Aktualisierung.STAND);
    }

    void beendeRunde() {
        for (Spieler spieler : this.teilnehmer) {
            this.ruecknahmen.add(spieler.index(), this.spielstaende.get(spieler.index()));
            this.spielstaende.add(spieler.index(), spieler.endsumme());
            this.verlaeufe.get(spieler.index()).set(this.spielindex, this.spielstaende.get(spieler.index()));
        }
        this.fireStateChanged(Aktualisierung.STAND);
    }

    void beendeSpiel() {
        this.schliesse();
        this.einordne();
        this.aktualisiere();
        this.eroeffne();
        this.fireStateChanged(Aktualisierung.SPIEL_ENDE);
    }

    void verfolge(Variante variante, int maximalanzahl, ArrayList<Spieler> teilnehmer, int mittelwert, int abweichung, ArrayList<ArrayList<Integer>> verlaeufe, ArrayList<Integer> turnierstaende) {
        this.teilnehmer = teilnehmer;
        this.variante = variante;
        this.maximalanzahl = maximalanzahl;
        this.mittelwert = mittelwert;
        this.abweichung = abweichung;
        this.verlaeufe = verlaeufe;
        this.turnierstaende = turnierstaende;
        this.spielindex = verlaeufe.get(teilnehmer.get(0).index()).size() - 1;
        this.ruecknahmen = new ArrayList(teilnehmer.size());
        this.spielstaende = new ArrayList(teilnehmer.size());
        this.siege = new ArrayList(teilnehmer.size());
        for (Spieler spieler : teilnehmer) {
            this.spielstaende.add(spieler.index(), verlaeufe.get(spieler.index()).get(this.spielindex));
            this.siege.add(0);
        }
        int s = 0;
        while (s < this.spielindex) {
            int max = 0;
            for (Spieler spieler : teilnehmer) {
                max = Math.max(spieler.endsumme(), max);
            }
            for (Spieler spieler : teilnehmer) {
                if (spieler.endsumme() != max) continue;
                this.siege.set(spieler.index(), this.siege.get(spieler.index()) + 1);
            }
            ++s;
        }
        if (this.spielindex == 0) {
            this.fireStateChanged(Aktualisierung.TURNIER_START);
        } else {
            this.fireStateChanged(Aktualisierung.TURNIER_WEITER);
        }
    }

    public static class Rang
    implements Serializable {
        private static final long serialVersionUID = 8690127540463640879L;
        private final ArrayList<Eintrag> eintraege = new ArrayList();
        private int punkte;
        private int rangnummer;

        public Eintrag neueintrag() {
            return this.eintraege.get(this.eintraege.size() - 1);
        }

        public int rangnummer() {
            return this.rangnummer;
        }

        ArrayList<Eintrag> eintraege() {
            return this.eintraege;
        }

        void notiere(Spieler spieler) {
            this.punkte = spieler.endsumme();
            Eintrag eintrag = new Eintrag(spieler.anzeigename(), DateFormat.getDateInstance(2, Locale.GERMANY).format(new Date()));
            if (!spieler.real()) {
                eintrag.kommentiere("Erzielt durch Bot");
            } else if (spieler.stellvertretend()) {
                eintrag.kommentiere("Anderer Austragungsort");
            }
            this.eintraege.add(eintrag);
        }

        void platziere(int rangnummer) {
            this.rangnummer = rangnummer;
        }

        int punkte() {
            return this.punkte;
        }

        public static class Eintrag
        implements Serializable {
            private static final long serialVersionUID = -6067121882006385994L;
            private final String name;
            private final String datum;
            private String kommentar = null;

            Eintrag(String name, String datum) {
                this.name = name;
                this.datum = datum;
            }

            public String kommentar() {
                return this.kommentar;
            }

            public void kommentiere(String kommentar) {
                this.kommentar = kommentar;
            }

            public String name() {
                return this.name;
            }

            String datum() {
                return this.datum;
            }
        }
    }
}

