/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.auswertung;

import jafuffy.Eigenschaften;
import jafuffy.logik.Kategorie;
import jafuffy.logik.Spieler;
import jafuffy.logik.Wuerfel;
import jafuffy.logik.analyse.Analyse;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Aenderungen;
import java.io.Serializable;

public abstract class Auswertung
extends Aenderungen<Ablauf>
implements Serializable {
    private static final long serialVersionUID = -8998187500583793899L;
    protected final Analyse analyse;
    protected final Wuerfel[] wuerfelsatz;
    protected boolean sindTippsAngefordert;
    protected Spieler aktiver;

    protected Auswertung(Wuerfel[] wuerfelsatz, Analyse analyse) {
        this.wuerfelsatz = wuerfelsatz;
        this.analyse = analyse;
    }

    public abstract int abweichung();

    public Spieler aktiver() {
        return this.aktiver;
    }

    public void aktiviereTipps(boolean tipps) {
        if (tipps && !this.sindTippsAngefordert) {
            this.analyse.prognostiziere(this.aktiver);
            this.sindTippsAngefordert = true;
        }
        this.sindTippsAngefordert = tipps;
    }

    public Analyse analyse() {
        return this.analyse;
    }

    public void erstelleVorschlag() {
        this.aktiviereTipps(true);
        this.erstelleVorschlag(this.analyse.bester());
    }

    public void erstelleVorschlag(Kategorie kategorie) {
        Wuerfel[] wuerfelArray = this.wuerfelsatz;
        int n = this.wuerfelsatz.length;
        int n2 = 0;
        while (n2 < n) {
            Wuerfel wuerfel = wuerfelArray[n2];
            wuerfel.setzeVorschlag(this.analyse.erneut(kategorie, wuerfel));
            ++n2;
        }
        this.fireStateChanged(Ablauf.VORGESCHLAGEN);
    }

    public abstract int mittelwert();

    public void reagiereAufWurf(Spieler spieler) {
        this.aktiver = spieler;
        this.sindTippsAngefordert = false;
        this.analyse.errechne(spieler);
    }

    public boolean sindTippsAngefordert() {
        return this.sindTippsAngefordert;
    }

    public String spicker(Kategorie kategorie) {
        String text;
        if (Eigenschaften.GLOBAL.aktiv("Spicker") && this.aktiver.gewuerfelt() && this.aktiver.setzbar(kategorie) && kategorie.alle()) {
            int punkte = this.analyse.wert(kategorie);
            text = String.valueOf(Integer.valueOf(punkte).toString()) + (punkte != 1 ? " Punkte" : " Punkt");
            if (this.sindTippsAngefordert() && this.aktiver.real() && !this.aktiver.stellvertretend()) {
                text = "<html><p>" + text + "</p>" + "<p><small><i>Siehe auch Kontextmen\u00fc!</i></small></p>" + "<p><small><i>Beachte Men\u00fc \"Extras\".</i></small></p>" + "</html>";
            }
        } else {
            text = null;
        }
        return text;
    }

    public abstract String text(Kategorie var1);

    public abstract String toString();
}

