/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.netzwerk;

import jafuffy.logik.Kategorie;
import jafuffy.logik.Plan;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import jafuffy.netzwerk.Kontakt;
import jafuffy.netzwerk.ereignis.Ereignis;
import jafuffy.netzwerk.ereignis.Lebenszeichen;
import jafuffy.netzwerk.ereignis.Wuerfelabwahl;
import jafuffy.netzwerk.ereignis.Wuerfelanwahl;
import jafuffy.netzwerk.ereignis.Wurfdarlegung;
import jafuffy.netzwerk.ereignis.Wurfergebnis;
import jafuffy.netzwerk.ereignis.Wurfsetzung;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Vermittlung
extends Thread
implements ChangeListener {
    private static final int VERBINDUNGSTIMEOUT = 5000;
    private final ArrayList<Kanal> zielkanaele = new ArrayList(4);
    private final ArrayList<Kanal> quellkanaele = new ArrayList(4);
    private final ExecutorService exekutor = Executors.newSingleThreadExecutor();
    private final ServerSocket willkommen;
    private final Ueberwachung ueberwachung;
    private final Timer lebenszeichen;
    private final Bearbeiter bearbeiter;
    private final Stoerung stoerung;
    private CountDownLatch verbindungszaehler;
    private CountDownLatch aussetzungszaehler;
    private final ExecutorService ausfuehrer;

    public Vermittlung(Eroeffnung eroeffnung, Stoerung stoerung) {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
        }
        catch (IOException ausnahme) {
            ausnahme.printStackTrace();
        }
        this.willkommen = socket;
        this.ueberwachung = new Ueberwachung();
        this.lebenszeichen = new Timer();
        this.ausfuehrer = Executors.newSingleThreadExecutor();
        this.bearbeiter = new Bearbeiter(eroeffnung);
        this.stoerung = stoerung;
    }

    @Override
    public void run() {
        do {
            try {
                this.behandle(this.willkommen.accept());
            }
            catch (SocketException socketException) {
            }
            catch (Exception ausnahme) {
                this.schliesse();
                this.stoerung.abbreche(ausnahme);
            }
        } while (this.verbindungszaehler.getCount() > 0L && !this.willkommen.isClosed());
        try {
            this.willkommen.close();
        }
        catch (IOException ausnahme) {
            ausnahme.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent aenderungsereignis) {
        if (Umschlag.adressiert(aenderungsereignis, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(aenderungsereignis);
            Ablauf ereignis = (Ablauf)((Object)umschlag.ereignis());
            switch (ereignis) {
                case START: {
                    this.ueberwache();
                    this.ueberwachung.aktiviere(true);
                    break;
                }
                case SPIEL: {
                    this.ueberwachung.aktiviere(true);
                    this.aussetzungszaehler.countDown();
                    break;
                }
                case WECHSEL: {
                    this.aussetzungszaehler = new CountDownLatch(1);
                    break;
                }
                case RESULTAT: {
                    this.ueberwachung.aktiviere(false);
                    break;
                }
                case ENDE: 
                case ABBRUCH: {
                    if (this.aussetzungszaehler != null) {
                        this.aussetzungszaehler.countDown();
                    }
                    SwingUtilities.invokeLater(() -> this.schliesse());
                }
            }
        }
    }

    public void verknuepfe(Wurf[] wuerfe, Nachfuehrung nachfuehrung) {
        this.bearbeiter.verknuepfe(wuerfe, nachfuehrung);
    }

    public void verteile(Ereignis ereignis) throws Exception {
        Future<Void> fertig = this.exekutor.submit(() -> {
            this.verteile((Serializable)ereignis);
            return null;
        });
        fertig.get();
    }

    private void behandle(Socket socket) throws Exception {
        Bediener bediener = new Bediener(socket);
        bediener.start();
    }

    private void ueberwache() {
        this.lebenszeichen.schedule((TimerTask)this.ueberwachung, 5000L, 5000L);
    }

    void schliesse() {
        this.lebenszeichen.cancel();
        try {
            this.willkommen.close();
            for (Kanal kanal : this.quellkanaele) {
                kanal.schliesse();
            }
            this.quellkanaele.clear();
            for (Kanal kanal : this.zielkanaele) {
                kanal.schliesse();
            }
            this.zielkanaele.clear();
        }
        catch (SocketException kanal) {
        }
        catch (IOException ausnahme) {
            ausnahme.printStackTrace();
        }
    }

    ServerSocket socket() {
        return this.willkommen;
    }

    void verbinde(Kontakt[] kontakte, Kontakt vorortkontakt) {
        this.verbindungszaehler = new CountDownLatch(2 * (kontakte.length - 1));
        this.start();
        Kontakt[] kontaktArray = kontakte;
        int n = kontakte.length;
        int n2 = 0;
        while (n2 < n) {
            Kontakt kontakt = kontaktArray[n2];
            if (!vorortkontakt.equals(kontakt)) {
                try {
                    Socket socket = new Socket(kontakt.adresse(), kontakt.port());
                    ObjectOutputStream versandstrom = new ObjectOutputStream(socket.getOutputStream());
                    ObjectInputStream empfangsstrom = new ObjectInputStream(socket.getInputStream());
                    Kanal kanal = new Kanal(versandstrom, empfangsstrom);
                    System.out.println("? " + socket.getRemoteSocketAddress() + " > " + socket.getLocalSocketAddress() + " auf " + kanal);
                    kanal.anfrage();
                    this.zielkanaele.add(kanal);
                    System.out.println("? OK auf " + kanal);
                    this.verbindungszaehler.countDown();
                }
                catch (Exception ausnahme) {
                    ausnahme.printStackTrace();
                }
            }
            ++n2;
        }
    }

    synchronized void verteile(Serializable objekt) throws Exception {
        for (Kanal kanal : this.zielkanaele) {
            kanal.sende(objekt);
        }
        for (Kanal kanal : this.zielkanaele) {
            kanal.warte();
        }
    }

    boolean warte() throws InterruptedException {
        return this.verbindungszaehler.await(5000L, TimeUnit.MILLISECONDS);
    }

    private class Bearbeiter {
        private final Eroeffnung eroeffnung;
        private Wurf[] wuerfe;
        private Nachfuehrung nachfuehrung;

        Bearbeiter(Eroeffnung eroeffnung) {
            this.eroeffnung = eroeffnung;
        }

        void betrachte(Ereignis ereignis) {
            Class<?> klasse = ereignis.getClass();
            if (klasse == Plan.class) {
                this.eroeffnung.starte((Plan)ereignis);
            } else if (klasse == Wuerfelabwahl.class) {
                Wuerfelabwahl abwahl = (Wuerfelabwahl)ereignis;
                if (this.wuerfe != null) {
                    this.wuerfe[abwahl.index].waehle(false);
                }
            } else if (klasse == Wuerfelanwahl.class) {
                Wuerfelanwahl anwahl = (Wuerfelanwahl)ereignis;
                if (this.wuerfe != null) {
                    this.wuerfe[anwahl.index].waehle(true);
                }
            } else if (klasse == Wurfergebnis.class) {
                Wurfergebnis ergebnis = (Wurfergebnis)ereignis;
                if (this.wuerfe != null) {
                    this.wuerfe[ergebnis.index].uebertrage(ergebnis.augen);
                }
            } else if (klasse == Wurfdarlegung.class) {
                this.nachfuehrung.reagiere();
            } else if (klasse == Wurfsetzung.class) {
                Wurfsetzung setzung = (Wurfsetzung)ereignis;
                this.nachfuehrung.setze(setzung.kategorie);
            }
        }

        void verknuepfe(Wurf[] wuerfe, Nachfuehrung nachfuehrung) {
            this.wuerfe = wuerfe;
            this.nachfuehrung = nachfuehrung;
        }
    }

    private class Bediener
    extends Thread {
        private final Kanal kanal;

        Bediener(Socket socket) throws Exception {
            System.out.println("! " + socket.getRemoteSocketAddress() + " > " + socket.getLocalSocketAddress());
            this.kanal = new Kanal(new ObjectOutputStream(socket.getOutputStream()), new ObjectInputStream(socket.getInputStream()));
            this.kanal.annehme();
            Vermittlung.this.quellkanaele.add(this.kanal);
            Vermittlung.this.verbindungszaehler.countDown();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.prozessiere();
                }
            }
            catch (EOFException | SocketException ausnahme) {
            }
            catch (Exception ausnahme) {
                Vermittlung.this.schliesse();
                Vermittlung.this.stoerung.abbreche(ausnahme);
            }
        }

        private void prozessiere() throws Exception {
            Ereignis ereignis = this.kanal.empfange();
            Runnable auftrag = () -> {
                Vermittlung.this.bearbeiter.betrachte(ereignis);
                try {
                    this.kanal.bestaetige();
                }
                catch (IOException ausnahme) {
                    Vermittlung.this.stoerung.abbreche(ausnahme);
                }
            };
            if (Vermittlung.this.aussetzungszaehler == null) {
                SwingUtilities.invokeAndWait(auftrag);
            } else {
                Vermittlung.this.ausfuehrer.execute(() -> {
                    try {
                        Vermittlung.this.aussetzungszaehler.await();
                        SwingUtilities.invokeAndWait(auftrag);
                    }
                    catch (InterruptedException | InvocationTargetException ausnahme) {
                        Vermittlung.this.stoerung.abbreche(ausnahme);
                    }
                });
            }
        }
    }

    public static interface Eroeffnung {
        public void starte(Plan var1);
    }

    private static class Kanal {
        private static final String ANFRAGE = "JaFuffy?";
        private static final String ANFRAGEFEHLER = "Fehler in Verbindungsanfrage";
        private static final String ANNAHME = "JaFuffy!";
        private static final String ANNAHMEFEHLER = "Fehler in Verbindungsannahme";
        private static final String BESTAETIGUNG = "OK";
        private static final String BESTAETIGUNGSFEHLER = "Keine Best\u00e4tigung (OK) erhalten.";
        private final ObjectOutputStream versandstrom;
        private final ObjectInputStream empfangsstrom;

        Kanal(ObjectOutputStream versandstrom, ObjectInputStream empfangsstrom) {
            this.versandstrom = versandstrom;
            this.empfangsstrom = empfangsstrom;
        }

        void anfrage() throws Exception {
            this.sende(ANFRAGE);
            if (!this.empfangsstrom.readUTF().equals(ANNAHME)) {
                throw new Exception(ANNAHMEFEHLER);
            }
        }

        void annehme() throws Exception {
            if (!this.empfangsstrom.readUTF().equals(ANFRAGE)) {
                throw new Exception(ANFRAGEFEHLER);
            }
            this.sende(ANNAHME);
        }

        void bestaetige() throws IOException {
            this.sende(BESTAETIGUNG);
        }

        Ereignis empfange() throws ClassNotFoundException, IOException {
            return (Ereignis)this.empfangsstrom.readObject();
        }

        void schliesse() throws IOException {
            this.versandstrom.close();
            this.empfangsstrom.close();
        }

        void sende(Serializable objekt) throws IOException {
            this.versandstrom.writeObject(objekt);
            this.versandstrom.flush();
        }

        void sende(String text) throws IOException {
            this.versandstrom.writeUTF(text);
            this.versandstrom.flush();
        }

        void warte() throws Exception {
            if (!this.empfangsstrom.readUTF().equals(BESTAETIGUNG)) {
                throw new Exception(BESTAETIGUNGSFEHLER);
            }
        }
    }

    public static interface Nachfuehrung {
        public void reagiere();

        public void setze(Kategorie var1);
    }

    public static interface Stoerung {
        public void abbreche(Exception var1);
    }

    private class Ueberwachung
    extends TimerTask {
        private volatile boolean aktiv;

        private Ueberwachung() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    Vermittlung.this.verteile(new Lebenszeichen());
                }
                catch (Exception ausnahme) {
                    if (!this.aktiv) break block2;
                    Vermittlung.this.schliesse();
                    Vermittlung.this.stoerung.abbreche(ausnahme);
                }
            }
        }

        void aktiviere(boolean aktiv) {
            this.aktiv = aktiv;
        }
    }

    public static interface Wurf {
        public void uebertrage(int var1);

        public void waehle(boolean var1);
    }
}

