/******************************************************************************
 ** $Id$
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.netzwerk;

import java.util.LinkedHashSet;

/** Nachricht. */
class Nachricht extends Anmeldung {

    private static final long serialVersionUID = -471697858537523359L;

    /** Die zwischen Spielern ausgetauschte Nachricht. */
    private final String text;

    /**
     * Erstellt eine Nachricht zwecks Kommunikation zwischen Spielern.
     *
     * @param kontakt
     *            Kontaktdaten des Absenders.
     * @param teilnehmer
     *            Teilnehmer an der Austragungssttte des Absenders, darf null sein.
     * @param text
     *            Nachricht.
     */
    Nachricht(Kontakt kontakt, LinkedHashSet<String> teilnehmer, String text) {
        super(kontakt, teilnehmer);
        this.text = text;
    }

    /** Liefert den optionalen Nachrichtentext. */
    String text() {
        return text;
    }

}