/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.Eigenschaften;
import jafuffy.bedienung.Eroeffnung;
import jafuffy.bedienung.Fenster;
import jafuffy.bedienung.Grafik;
import jafuffy.bedienung.Oberflaeche;
import jafuffy.bedienung.netzwerk.Organisation;
import jafuffy.logik.Beginner;
import jafuffy.logik.Bot;
import jafuffy.logik.Manager;
import jafuffy.logik.Name;
import jafuffy.logik.Plan;
import jafuffy.logik.Variante;
import jafuffy.netzwerk.Leitung;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class Absprache
extends JDialog
implements PropertyChangeListener {
    private static final ImageIcon AKTIVBOT = Grafik.icon("Aktivbot.png");
    private static final ImageIcon RUHEBOT = Grafik.icon("Ruhebot.png");
    private static final ImageIcon START = Grafik.icon("Start.png");
    private static final ImageIcon ABBRUCH = Grafik.icon("Abbruch.png");
    private static final ImageIcon NETZWERK = Grafik.icon("Netzwerk.png");
    private static final int FELDRAHMENABSTAND = 4;
    private static final int DIALOGRAHMENABSTAND = 8;
    private static final int AUSWAHLLAENGE = 240;
    private static final int BUTTONABSTAND = 8;
    private static final int FEINTICKS = 1;
    private static final int ORIENTIERUNGSTICKS = 5;
    private static final int SPALTEN = 8;
    private static final int TICKLABELS = 5;
    private static final String ABSTIMMUNG = "Abstimmung";
    private static final String HINWEIS = "Hinweis";
    public static final int ANZAHL = 25;
    private final JSlider anzahlschieberegler = new JSlider(0, 25);
    private final JComboBox<Beginner> beginnmodusauswahl = new JComboBox<Beginner>(Beginner.values());
    private final Eigenschaften eigenschaften;
    private final JComboBox<Variante> variantenauswahl = new JComboBox<Variante>(Variante.values());
    private final Nominierung[] nominierungen = new Nominierung[4];
    private final Botselektion[] botselektionen = new Botselektion[4];
    private final JButton abstimmung = new JButton("Abstimmung \u00fcber Netzwerk", NETZWERK);
    private final JPanel abstimmungsfeld = new JPanel(new CardLayout());
    private final JButton start = new JButton("Start");
    private final JButton abbruch = new JButton("Abbruch");
    private Leitung leitung;

    public Absprache(Eigenschaften eigenschaften, Fenster fenster, Manager manager) {
        super(fenster);
        this.eigenschaften = eigenschaften;
        UIManager.addPropertyChangeListener(this);
        this.setTitle("JaFuffy (Absprache f\u00fcr neues Turnier)");
        this.setIconImages(Oberflaeche.LOGOS);
        this.setModal(true);
        this.baue();
        this.initialisiere();
        this.installiere(manager);
        this.aktualisiere();
        this.pack();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Beginnen")) {
            this.setLocationRelativeTo(this.getOwner());
            this.setVisible(true);
        } else if (event.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this);
            this.pack();
        }
    }

    private void aktualisiere() {
        int spieleranzahl = 0;
        int botanzahl = 0;
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            if (!nominierung.toString().isEmpty()) {
                ++spieleranzahl;
                if (nominierung.kuenstlich()) {
                    ++botanzahl;
                }
            }
            ++n2;
        }
        boolean mehrfach = false;
        int i = 0;
        while (i < this.nominierungen.length) {
            int j = i + 1;
            while (j < this.nominierungen.length) {
                mehrfach = mehrfach || !this.nominierungen[i].toString().isEmpty() && !this.nominierungen[i].toString().isEmpty() && Objects.equals(this.nominierungen[i].toString(), this.nominierungen[j].toString());
                ++j;
            }
            ++i;
        }
        this.beginnmodusauswahl.setEnabled(spieleranzahl > 1 && (this.leitung == null || this.leitung.vorsitzend()));
        this.start.setEnabled(spieleranzahl > 0 && !mehrfach && (this.leitung == null || this.leitung.phase() == Leitung.Phase.BEREIT));
        this.abstimmung.setEnabled(spieleranzahl > botanzahl);
    }

    private JPanel anzahlauswahl() {
        JLabel label = new JLabel("Anzahl der Spiele im Turnier");
        label.setAlignmentX(0.5f);
        this.anzahlschieberegler.setMinorTickSpacing(1);
        this.anzahlschieberegler.setMajorTickSpacing(5);
        this.anzahlschieberegler.setPaintTicks(true);
        this.anzahlschieberegler.setPaintLabels(true);
        this.anzahlschieberegler.setSnapToTicks(true);
        Hashtable<Integer, JComponent> hashtable = this.anzahlschieberegler.createStandardLabels(5);
        hashtable.put(0, new JLabel("beliebig"));
        this.anzahlschieberegler.setLabelTable(hashtable);
        JPanel anzahlfeld = new JPanel();
        anzahlfeld.setLayout(new BoxLayout(anzahlfeld, 1));
        anzahlfeld.add(label);
        anzahlfeld.add(this.anzahlschieberegler);
        anzahlfeld.add(Box.createHorizontalStrut(240));
        return anzahlfeld;
    }

    private void baue() {
        JPanel regelnfeld = new JPanel(new BorderLayout());
        regelnfeld.add((Component)this.regelnfeld(), "Center");
        JPanel buttonspalte = new JPanel(new BorderLayout());
        buttonspalte.add((Component)this.buttonspalte(), "Center");
        JPanel feld = new JPanel();
        feld.setBorder(new EmptyBorder(8, 8, 8, 8));
        feld.setLayout(new BoxLayout(feld, 0));
        feld.add(this.nominierungsfeld());
        feld.add(Box.createHorizontalStrut(4));
        feld.add(regelnfeld);
        feld.add(Box.createHorizontalStrut(4));
        feld.add(buttonspalte);
        this.setContentPane(feld);
    }

    private JPanel buttonspalte() {
        this.abbruch.setIcon(ABBRUCH);
        this.abbruch.setHorizontalTextPosition(0);
        this.abbruch.setVerticalTextPosition(3);
        this.start.setToolTipText("<html><p>Beginnt ein neues Turnier.</p><p>Mindestens ein Spielername ist n\u00f6tig und alle Spielernamen m\u00fcssen verschieden sein.</p><p>Beim Netzwerkbetrieb m\u00fcssen sich alle Austragungsorte miteinander verbunden haben.</p></html>");
        this.start.setIcon(START);
        this.start.setHorizontalTextPosition(0);
        this.start.setVerticalTextPosition(3);
        JPanel buttonspalte = new JPanel(new GridLayout(0, 1, 0, 8));
        buttonspalte.setBorder(BorderFactory.createEmptyBorder(20, 4, 16, 4));
        buttonspalte.add(this.start);
        buttonspalte.add(this.abbruch);
        return buttonspalte;
    }

    private void entferne(Nominierung verursacher, String botname) {
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            if (nominierung != verursacher && nominierung.kuenstlich()) {
                nominierung.entferne(botname);
            }
            ++n2;
        }
    }

    private int eroeffnungsindex(ArrayList<Name> namen) {
        int index = 0;
        if (namen.size() > 1) {
            Eroeffnung eroeffnung = new Eroeffnung(namen);
            eroeffnung.addPropertyChangeListener(this);
            eroeffnung.setLocationRelativeTo(this);
            eroeffnung.setVisible(true);
            eroeffnung.dispose();
            index = eroeffnung.eroeffnungsindex();
        }
        return index;
    }

    private void erweitere(Nominierung verursacher, String botname) {
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            if (nominierung != verursacher && nominierung.kuenstlich()) {
                nominierung.erweitere(botname);
            }
            ++n2;
        }
    }

    private boolean frei(String botname) {
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            if (botname.equals(nominierung.toString())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void initialisiere() {
        ArrayList<String> botnamen = new ArrayList<String>();
        int i = 0;
        while (i < 4) {
            String verwaltungsname = this.eigenschaften.verwaltungsname(i);
            if (Name.kuenstlich(verwaltungsname)) {
                botnamen.add(Name.anzeigename(verwaltungsname));
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            this.nominierungen[i].uebernehme(this.eigenschaften.verwaltungsname(i), botnamen);
            this.botselektionen[i].setSelected(this.nominierungen[i].kuenstlich());
            ++i;
        }
        this.anzahlschieberegler.setValue(Integer.parseInt(this.eigenschaften.getProperty("Anzahl")));
        this.beginnmodusauswahl.setSelectedIndex(this.eigenschaften.beginnmodus());
        this.variantenauswahl.setSelectedIndex(this.eigenschaften.variante());
        this.leitung = null;
    }

    private void installiere(Manager manager) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ereignis) {
                Absprache.this.abbruch.doClick();
            }
        });
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            nominierung.installiere();
            ++n2;
        }
        this.abstimmung.addActionListener(ereignis -> {
            try {
                this.organisiere(manager);
            }
            catch (SocketException | UnknownHostException ausnahme) {
                ausnahme.printStackTrace();
                JOptionPane.showMessageDialog(this, "Kein Turnier \u00fcber Netzwerk m\u00f6glich!\nKein Netzwerk verf\u00fcgbar?\nJava-Exception:\n" + ausnahme, "JaFuffy (Fehler)", 0);
            }
        });
        this.abstimmung.setToolTipText("<html><p>Organisiert ein Turnier \u00fcber ein lokales Netzwerk.</p><p>Erlaubt Hinzuf\u00fcgen von Mitspielern, die \u00fcber das Netzwerk teilnehmen.</p><p>Bots sind von der Teilnahme ausgeschlossen.</p><br><p><small><em>Experimentell! Volle Funktionalit\u00e4t steht nicht zur Verf\u00fcgung.</em></small></p></html>");
        this.abbruch.addActionListener(ereignis -> {
            this.initialisiere();
            this.aktualisiere();
            this.setVisible(false);
            this.waehleAbstimmungssicht(ABSTIMMUNG);
        });
        this.start.addActionListener(ereignis -> {
            if (this.leitung == null) {
                manager.betreibe(this.plan());
            } else {
                this.leitung.betreibe(manager, this.plan());
                this.leitung = null;
            }
            this.setVisible(false);
            this.waehleAbstimmungssicht(ABSTIMMUNG);
        });
        this.getRootPane().setDefaultButton(this.start);
    }

    private JPanel konfiguriereAbstimmungsfeld() {
        this.abstimmungsfeld.setBorder(BorderFactory.createEmptyBorder(8, 0, 2, 0));
        this.abstimmungsfeld.add((Component)this.abstimmung, ABSTIMMUNG);
        JLabel hinweis = new JLabel("Teilnehmer wie eben zuvor abgestimmt");
        hinweis.setEnabled(false);
        hinweis.setHorizontalAlignment(0);
        this.abstimmungsfeld.add((Component)hinweis, HINWEIS);
        return this.abstimmungsfeld;
    }

    private void konfiguriereBeginnmodusauswahl() {
        this.beginnmodusauswahl.setAlignmentX(0.5f);
        this.beginnmodusauswahl.setToolTipText("Auswahl, welcher Mitspieler jedes neue Spiel beginnt");
    }

    private void konfiguriereVariantenauswahl() {
        this.variantenauswahl.setActionCommand("Var");
        this.variantenauswahl.setAlignmentX(0.5f);
        this.variantenauswahl.setToolTipText("Nach welchen Spielregeln soll gespielt werden?");
    }

    private JPanel nominierungsfeld() {
        JPanel nominierungsfeld = new JPanel(new BorderLayout());
        nominierungsfeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Namen"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        nominierungsfeld.add((Component)this.spielerfestlegung(), "First");
        nominierungsfeld.add((Component)this.konfiguriereAbstimmungsfeld(), "Center");
        return nominierungsfeld;
    }

    private void organisiere(Manager manager) throws UnknownHostException, SocketException {
        LinkedHashSet<String> vorortnamen = this.vorortnamen();
        this.leitung = new Leitung(() -> {
            this.waehleAbstimmungssicht(ABSTIMMUNG);
            this.uebernehmeTeilnehmer(vorortnamen);
            this.leitung = null;
        }, manager, vorortnamen);
        this.abstimmung.addActionListener(this.leitung);
        this.start.setEnabled(false);
        this.setEnabled(false);
        Organisation organisation = new Organisation(this.leitung, vorortnamen.size());
        organisation.setLocationRelativeTo(this);
        organisation.setVisible(true);
        this.abstimmung.removeActionListener(this.leitung);
        if (this.leitung.phase() == Leitung.Phase.ABBRUCH) {
            this.leitung = null;
            this.setEnabled(true);
            this.start.setEnabled(true);
            return;
        }
        Rezeptionist rezeptionist = new Rezeptionist();
        Stornierer stornierer = this.stornierer(rezeptionist);
        rezeptionist.verknuepfe(stornierer);
        stornierer.starte();
        rezeptionist.execute();
    }

    private Plan plan() {
        Plan plan;
        if (this.leitung == null || this.leitung.phase() == Leitung.Phase.BETRIEB) {
            ArrayList<Name> teilnehmer = this.uebernehmeTeilnehmer();
            plan = new Plan(teilnehmer, this.uebernehmeBeginnmodus(), this.uebernehmeVariante(), this.uebernehmeAnzahl(), this.eroeffnungsindex(teilnehmer));
        } else if (this.leitung.vorsitzend()) {
            this.uebernehmeTeilnehmer(this.leitung.vorortnamen());
            ArrayList<Name> teilnehmer = this.uebernehmeTeilnehmer(this.leitung.gesamtnamen(), this.leitung.vorortnamen());
            Plan hilfsplan = new Plan(teilnehmer, this.uebernehmeBeginnmodus(), this.uebernehmeVariante(), this.uebernehmeAnzahl(), this.eroeffnungsindex(teilnehmer));
            try {
                this.leitung.informiere(hilfsplan);
            }
            catch (Exception ausnahme) {
                ausnahme.printStackTrace();
                JOptionPane.showMessageDialog(this, "St\u00f6rung im Turnierbetrieb \u00fcber Netzwerk!\nTurnier muss neu gestartet werden.\n\nJava-Exception:\n" + ausnahme.getLocalizedMessage(), "JaFuffy (Fehler)", 0);
                this.storniere();
                hilfsplan = null;
            }
            plan = hilfsplan;
        } else {
            plan = null;
        }
        return plan;
    }

    private JPanel regelnfeld() {
        this.konfiguriereVariantenauswahl();
        this.konfiguriereBeginnmodusauswahl();
        JPanel regelnfeld = new JPanel();
        regelnfeld.setLayout(new BoxLayout(regelnfeld, 1));
        regelnfeld.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Bedingungen"), BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        regelnfeld.add(this.beginnmodusauswahl);
        regelnfeld.add(Box.createVerticalStrut(1));
        regelnfeld.add(Box.createVerticalGlue());
        regelnfeld.add(Box.createVerticalStrut(1));
        regelnfeld.add(this.variantenauswahl);
        regelnfeld.add(Box.createVerticalStrut(4));
        regelnfeld.add(Box.createVerticalGlue());
        regelnfeld.add(Box.createVerticalStrut(4));
        regelnfeld.add(this.anzahlauswahl());
        regelnfeld.add(Box.createVerticalGlue());
        return regelnfeld;
    }

    private JPanel spielerfestlegung() {
        JPanel spielerfestlegung = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 1;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(1, 0, 1, 0);
        int i = 0;
        while (i < 4) {
            constraints.anchor = 21;
            constraints.gridx = 0;
            constraints.gridy = i;
            constraints.ipadx = 8;
            constraints.fill = 3;
            constraints.weightx = 0.0;
            this.nominierungen[i] = new Nominierung(this);
            this.variantenauswahl.addActionListener(this.nominierungen[i]);
            this.botselektionen[i] = new Botselektion(this.nominierungen[i], this.variantenauswahl);
            this.variantenauswahl.addActionListener(this.botselektionen[i]);
            spielerfestlegung.add((Component)this.botselektionen[i], constraints);
            constraints.anchor = 10;
            constraints.gridx = 1;
            constraints.ipadx = 4;
            constraints.weightx = 0.0;
            JLabel kopf = new JLabel(String.valueOf(i + 1) + ". Spieler: ", 0);
            spielerfestlegung.add((Component)kopf, constraints);
            constraints.anchor = 22;
            constraints.gridx = 2;
            constraints.ipadx = 0;
            constraints.fill = 1;
            constraints.weightx = 1.0;
            spielerfestlegung.add((Component)this.nominierungen[i], constraints);
            ++i;
        }
        return spielerfestlegung;
    }

    private void storniere() {
        this.abbruch.doClick();
    }

    private Stornierer stornierer(final Rezeptionist rezeptionist) {
        if (this.leitung.vorsitzend()) {
            return new Stornierer(this){

                @Override
                boolean ueberpruefe() {
                    if (this.abgelaufen() && leitung.phase() != Leitung.Phase.BETRIEB) {
                        SwingUtilities.invokeLater(this.fristablauf);
                    }
                    return this.abgelaufen();
                }
            };
        }
        return new Stornierer(this, this.leitung.vorsitz()){

            @Override
            boolean ueberpruefe() {
                if (leitung.phase() == Leitung.Phase.VERBINDUNG) {
                    rezeptionist.cancel(true);
                } else if (leitung.phase() != Leitung.Phase.BETRIEB) {
                    if (this.isCanceled()) {
                        this.storniere();
                    } else {
                        SwingUtilities.invokeLater(this.fristablauf);
                    }
                }
                return true;
            }
        };
    }

    private int uebernehmeAnzahl() {
        this.eigenschaften.setProperty("Anzahl", Integer.toString(this.anzahlschieberegler.getValue()));
        return this.anzahlschieberegler.getValue();
    }

    private Beginner uebernehmeBeginnmodus() {
        Beginner beginnmodus = Beginner.values()[this.beginnmodusauswahl.getSelectedIndex()];
        this.eigenschaften.setProperty("Beginnmodus", beginnmodus.name());
        return beginnmodus;
    }

    private ArrayList<Name> uebernehmeTeilnehmer() {
        ArrayList<Name> namen = new ArrayList<Name>(4);
        int index = 0;
        while (index < 4) {
            this.eigenschaften.setProperty("Name" + index, "");
            ++index;
        }
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            String anzeigename = nominierung.toString();
            if (!anzeigename.isEmpty()) {
                Name.Typus typus = nominierung.kuenstlich() ? Name.Typus.BOT : Name.Typus.SPIELER;
                Name name = new Name(anzeigename, typus, namen.size());
                this.eigenschaften.setProperty("Name" + namen.size(), name.verwaltungsname());
                namen.add(name);
            }
            ++n2;
        }
        return namen;
    }

    private void uebernehmeTeilnehmer(LinkedHashSet<String> vorortnamen) {
        Iterator iterator = vorortnamen.iterator();
        int index = 0;
        while (index < 4) {
            String verwaltungsname;
            String anzeigename;
            if (iterator.hasNext()) {
                anzeigename = (String)iterator.next();
                verwaltungsname = Name.verwaltungsname(anzeigename, Name.Typus.SPIELER);
            } else {
                anzeigename = "";
                verwaltungsname = "";
            }
            this.nominierungen[index].uebernehme(verwaltungsname, null);
            this.eigenschaften.setProperty("Name" + index, verwaltungsname);
            ++index;
        }
    }

    private ArrayList<Name> uebernehmeTeilnehmer(LinkedHashSet<String> gesamtnamen, LinkedHashSet<String> vorortnamen) {
        ArrayList<Name> namen = new ArrayList<Name>(4);
        for (String anzeigename : gesamtnamen) {
            Name.Typus typus = vorortnamen.contains(anzeigename) ? Name.Typus.SPIELER : Name.Typus.VERTRETER;
            namen.add(new Name(anzeigename, typus, namen.size()));
        }
        return namen;
    }

    private Variante uebernehmeVariante() {
        Variante variante = (Variante)((Object)this.variantenauswahl.getSelectedItem());
        this.eigenschaften.setProperty("Variante", variante.name());
        return variante;
    }

    private void uebertrageNamen(LinkedHashSet<String> gesamtnamen, LinkedHashSet<String> vorortnamen) {
        Iterator iterator = gesamtnamen.iterator();
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            String name = "";
            if (iterator.hasNext()) {
                name = (String)iterator.next();
                name = vorortnamen.contains(name) ? String.valueOf(Name.Typus.SPIELER.praefix) + name : String.valueOf(Name.Typus.VERTRETER.praefix) + name;
            }
            nominierung.uebernehme(name, null);
            ++n2;
        }
    }

    private LinkedHashSet<String> vorortnamen() {
        LinkedHashSet<String> teilnehmer = new LinkedHashSet<String>();
        Nominierung[] nominierungArray = this.nominierungen;
        int n = this.nominierungen.length;
        int n2 = 0;
        while (n2 < n) {
            Nominierung nominierung = nominierungArray[n2];
            String name = nominierung.toString();
            if (!name.isEmpty() && !nominierung.kuenstlich()) {
                teilnehmer.add(name);
            }
            ++n2;
        }
        return teilnehmer;
    }

    private void waehleAbstimmungssicht(String sicht) {
        ((CardLayout)this.abstimmungsfeld.getLayout()).show(this.abstimmungsfeld, sicht);
        boolean aktiv = ABSTIMMUNG.equals(sicht);
        JComponent[] jComponentArray = this.botselektionen;
        int n = this.botselektionen.length;
        int n2 = 0;
        while (n2 < n) {
            Botselektion botselektor = jComponentArray[n2];
            botselektor.setEnabled(aktiv);
            ++n2;
        }
        jComponentArray = this.nominierungen;
        n = this.nominierungen.length;
        n2 = 0;
        while (n2 < n) {
            JComponent nominierung = jComponentArray[n2];
            ((Nominierung)nominierung).aktiviere(aktiv);
            ++n2;
        }
        this.start.setIcon(aktiv ? START : NETZWERK);
    }

    private static class Botselektion
    extends JCheckBox
    implements ActionListener {
        private static final Color BOT_INAKTIV_FARBE = Color.GRAY;
        private static final Color BOT_AKTIV_FARBE = Color.ORANGE.darker();
        private final JComboBox<Variante> variantenauswahl;

        Botselektion(Nominierung nominierung, JComboBox<Variante> variantenauswahl) {
            super("Bot");
            this.variantenauswahl = variantenauswahl;
            this.addActionListener(nominierung);
            this.setIcon(RUHEBOT);
            this.setRolloverIcon(AKTIVBOT);
            this.setSelectedIcon(AKTIVBOT);
            this.setToolTipText("<html><p>Wenn angew\u00e4hlt, \u00fcbernimmt <i>JaFuffy</i> die Rolle des Spielers.</p><p><small>Spielst\u00e4rke im Men\u00fc: Einstellungen&rarr;Botverhalten&rarr;Spielst\u00e4rke der Bots...</small></p><p><small>Bot steht bei erweiterten Regeln nicht zur Verf\u00fcgung.</small></p></html>");
            this.addActionListener(this);
            boolean botfaehig = variantenauswahl.getSelectedItem() != Variante.ERWEITERT;
            this.setEnabled(botfaehig);
            if (botfaehig) {
                if (this.isSelected()) {
                    this.setForeground(BOT_AKTIV_FARBE);
                } else {
                    this.setForeground(BOT_INAKTIV_FARBE);
                }
            } else {
                this.setSelected(false);
                this.setForeground(Color.LIGHT_GRAY);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            boolean botfaehig = this.variantenauswahl.getSelectedItem() != Variante.ERWEITERT;
            this.setEnabled(botfaehig);
            if (botfaehig) {
                if (this.isSelected()) {
                    this.setForeground(BOT_AKTIV_FARBE);
                } else {
                    this.setForeground(BOT_INAKTIV_FARBE);
                }
            } else {
                this.setSelected(false);
                this.setForeground(Color.LIGHT_GRAY);
            }
        }
    }

    private static class Nominierung
    extends JPanel
    implements ActionListener {
        private static final String MENSCH = "Mensch";
        private static final String BOT = "Bot";
        private static final int EINGABELAENGE = 14;
        private final Absprache absprache;
        private final JTextField spielernameneingabe = new JTextField(8);
        private final JComboBox<String> botnamenauswahl = new JComboBox();
        private boolean kuenstlich;

        Nominierung(Absprache absprache) {
            super(new CardLayout());
            this.absprache = absprache;
            this.spielernameneingabe.setToolTipText("<html><p>Eingabe der Spielernamen, bis zu 14 Zeichen.</p><p>Namen k\u00f6nnen nicht mit Leer- oder Anf\u00fchrungszeichen beginnen.</p></html>");
            this.add((Component)this.spielernameneingabe, MENSCH);
            this.add(this.botnamenauswahl, BOT);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JComboBox variantenauswahl;
            String kommando = event.getActionCommand();
            if (kommando.equals(BOT)) {
                this.botnamenauswahl.removeAllItems();
                this.kuenstlich = ((JCheckBox)event.getSource()).isSelected();
                CardLayout layout = (CardLayout)this.getLayout();
                if (this.kuenstlich) {
                    String[] stringArray = Bot.BOTNAMEN;
                    int n = Bot.BOTNAMEN.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String botname = stringArray[n2];
                        if (this.absprache.frei(botname)) {
                            this.botnamenauswahl.addItem(botname);
                        }
                        ++n2;
                    }
                    layout.show(this, BOT);
                } else {
                    layout.show(this, MENSCH);
                }
                this.absprache.aktualisiere();
            } else if (kommando.equals("Var") && (variantenauswahl = (JComboBox)event.getSource()).getSelectedItem() == Variante.ERWEITERT) {
                this.kuenstlich = false;
                CardLayout layout = (CardLayout)this.getLayout();
                layout.show(this, MENSCH);
            }
        }

        @Override
        public String toString() {
            return this.kuenstlich ? (String)this.botnamenauswahl.getSelectedItem() : this.spielernameneingabe.getText().trim();
        }

        void aktiviere(boolean aktiv) {
            this.spielernameneingabe.setEnabled(aktiv);
        }

        void entferne(String botname) {
            this.botnamenauswahl.removeItem(botname);
        }

        void erweitere(String botname) {
            this.botnamenauswahl.addItem(botname);
        }

        void installiere() {
            ((AbstractDocument)this.spielernameneingabe.getDocument()).setDocumentFilter(new Filter());
            this.spielernameneingabe.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent event) {
                    absprache.aktualisiere();
                }

                @Override
                public void insertUpdate(DocumentEvent event) {
                    absprache.aktualisiere();
                }

                @Override
                public void removeUpdate(DocumentEvent event) {
                    absprache.aktualisiere();
                }
            });
            this.botnamenauswahl.addItemListener(event -> {
                if (event.getStateChange() == 1) {
                    this.absprache.entferne(this, event.getItem().toString());
                } else {
                    this.absprache.erweitere(this, event.getItem().toString());
                }
            });
        }

        boolean kuenstlich() {
            return this.kuenstlich;
        }

        void uebernehme(String verwaltungsname, List<String> botnamen) {
            CardLayout layout = (CardLayout)this.getLayout();
            this.kuenstlich = Name.kuenstlich(verwaltungsname);
            if (this.kuenstlich) {
                this.botnamenauswahl.addItem(Name.anzeigename(verwaltungsname));
                String[] stringArray = Bot.BOTNAMEN;
                int n = Bot.BOTNAMEN.length;
                int n2 = 0;
                while (n2 < n) {
                    String botname = stringArray[n2];
                    if (!botnamen.contains(botname)) {
                        this.botnamenauswahl.addItem(botname);
                    }
                    ++n2;
                }
                layout.show(this, BOT);
            } else {
                this.spielernameneingabe.setText(Name.anzeigename(verwaltungsname));
                layout.show(this, MENSCH);
            }
        }

        private static class Filter
        extends DocumentFilter {
            private Filter() {
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                if (this.gefiltert(fb, offset, 0, string)) {
                    return;
                }
                super.insertString(fb, offset, string, attr);
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                String string = fb.getDocument().getText(length, fb.getDocument().getLength() - length);
                if (this.gefiltert(fb, offset, fb.getDocument().getLength(), string)) {
                    return;
                }
                super.remove(fb, offset, length);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
                if (this.gefiltert(fb, offset, length, string)) {
                    return;
                }
                super.replace(fb, offset, length, string, attr);
            }

            private boolean gefiltert(DocumentFilter.FilterBypass fb, int offset, int laenge, String string) {
                boolean gefiltert;
                boolean bl = gefiltert = fb.getDocument().getLength() - laenge + string.length() > 14 || offset == 0 && Name.anfangverboten(string);
                if (gefiltert) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return gefiltert;
            }
        }
    }

    private class Rezeptionist
    extends SwingWorker<Boolean, Void> {
        private final boolean vorsitzend;
        private Stornierer stornierer;

        Rezeptionist() {
            this.vorsitzend = Absprache.this.leitung.vorsitzend();
            Absprache.this.waehleAbstimmungssicht(Absprache.HINWEIS);
            this.addPropertyChangeListener(ereignis -> {
                switch ((SwingWorker.StateValue)((Object)((Object)ereignis.getNewValue()))) {
                    case DONE: {
                        Absprache.this.uebertrageNamen(Absprache.this.leitung.gesamtnamen(), Absprache.this.leitung.vorortnamen());
                    }
                }
            });
        }

        @Override
        protected Boolean doInBackground() throws InterruptedException {
            return Absprache.this.leitung.warte();
        }

        @Override
        protected void done() {
            try {
                Absprache.this.setEnabled(true);
                if (((Boolean)this.get()).booleanValue()) {
                    Absprache.this.setVisible(this.vorsitzend);
                    Absprache.this.start.setEnabled(true);
                    return;
                }
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException | ExecutionException ausnahme) {
                ausnahme.printStackTrace();
            }
            this.stornierer.stoppe();
            this.stornierer = null;
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(Absprache.this, "Kein Turnier \u00fcber Netzwerk zustande gekommen!\nVerbindungen zwischen den Austragungsorten konnten nicht hergestellt werden.\nBitte erneut von Beginn an versuchen.", "JaFuffy (Fehler)", 0);
                Absprache.this.storniere();
            });
        }

        void verknuepfe(Stornierer stornierer) {
            this.stornierer = stornierer;
        }
    }

    private abstract class Stornierer
    extends ProgressMonitor {
        private static final int FRISTZEIT = 30;
        private static final int ERINNERUNGSZEIT = 10000;
        private static final int AKTUALISIERUNGSPERIODE = 500;
        private static final int MAXIMUM = 60;
        private volatile int zeit;
        private final Timer fortschrittsaktualisierung;
        private final ActionListener abbruchbeobachter;
        private final ActionListener okbeobachter;
        protected final Runnable fristablauf;

        private Stornierer(Component heimatkomponente, Object information, int frist, int erinnerung) {
            super(heimatkomponente, information, null, 0, frist);
            this.fortschrittsaktualisierung = new Timer(500, ereignis -> {
                ++this.zeit;
                if (Absprache.this.leitung == null || (this.abgelaufen() || this.isCanceled() || Absprache.this.leitung.phase() == Leitung.Phase.BETRIEB) && this.ueberpruefe()) {
                    this.entferne();
                } else {
                    this.setProgress(this.zeit);
                }
            });
            this.abbruchbeobachter = ereignis -> {
                this.entferne();
                this.deinstalliere();
                if (Absprache.this.leitung != null) {
                    Absprache.this.leitung.stoppe();
                }
                Absprache.this.leitung = null;
            };
            this.okbeobachter = ereignis -> {
                this.entferne();
                this.deinstalliere();
            };
            this.fristablauf = () -> {
                JOptionPane.showMessageDialog(heimatkomponente, "Frist abgelaufen,\nkein Turnier \u00fcber Netzwerk zustande gekommen.", "JaFuffy (Fristablauf)", 2);
                Absprache.this.storniere();
            };
            this.setMillisToDecideToPopup(erinnerung);
            this.installiere();
        }

        Stornierer() {
            this(absprache, (Object)"Frist zur Festlegung der Turnierbedingungen l\u00e4uft...\nAbbruch enfternt diese Erinnerung, Frist l\u00e4uft weiter.", 60, 10000);
        }

        Stornierer(String vorsitz) {
            this(absprache.getOwner(), (Object)("Warten auf die Festlegung der Turnierbedingungen durch\n\"" + vorsitz + "\".\n" + "Abbruch beseitigt alle Turniervorbereitungen."), 60, 0);
        }

        private void deinstalliere() {
            Absprache.this.abbruch.removeActionListener(this.abbruchbeobachter);
            Absprache.this.start.removeActionListener(this.okbeobachter);
        }

        private void entferne() {
            this.fortschrittsaktualisierung.stop();
            this.close();
        }

        private void installiere() {
            Absprache.this.abbruch.addActionListener(this.abbruchbeobachter);
            Absprache.this.start.addActionListener(this.okbeobachter);
            Absprache.this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent ereignis) {
                    Absprache.this.removeWindowListener(this);
                    Stornierer.this.entferne();
                    Stornierer.this.deinstalliere();
                    Absprache.this.storniere();
                }
            });
        }

        boolean abgelaufen() {
            return this.zeit >= this.getMaximum();
        }

        void starte() {
            this.fortschrittsaktualisierung.start();
        }

        void stoppe() {
            this.fortschrittsaktualisierung.stop();
            this.close();
        }

        abstract boolean ueberpruefe();
    }
}

