/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import jafuffy.bedienung.Verfolgung;
import jafuffy.bedienung.Wuerfelfeld;
import jafuffy.logik.Spieler;
import jafuffy.logik.Turnier;
import jafuffy.logik.ereignis.Ablauf;
import jafuffy.logik.ereignis.Umschlag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class Status
extends JPanel
implements ChangeListener {
    private static final int NACHRICHTENSCHRIFTGROESSE = 12;
    private static final int VERTIKALABSTAND = 4;
    private final Verfolgung verfolgung;
    private final JLabel nachricht = new JLabel();
    private final JLabel restanzeige = new JLabel();

    Status(Wuerfelfeld.Kontextmenue kontextmenue, Verfolgung verfolgung) {
        this.verfolgung = verfolgung;
        verfolgung.addMouseListener(kontextmenue);
        this.dekoriere(kontextmenue);
        this.baue();
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (Umschlag.adressiert(ce, Ablauf.class)) {
            Umschlag umschlag = Umschlag.ereignisbehaelter(ce);
            switch ((Ablauf)((Object)umschlag.ereignis())) {
                case START: 
                case SPIEL: 
                case GEWORFEN: 
                case FERTIG: 
                case RUECKGAENGIG: {
                    this.aktualisiere((Turnier)umschlag.quelle());
                    break;
                }
                case RESULTAT: {
                    this.beendeSpiel();
                    break;
                }
                case ABBRUCH: {
                    this.beendeTurnier("Das Turnier wurde vorzeitig abgebrochen.");
                    break;
                }
                case ENDE: {
                    this.beendeTurnier("Das Turnier ist beendet, die obige Tabelle zeigt den Ausgang!");
                    break;
                }
            }
            this.verfolgung.stateChanged(ce);
        }
    }

    private void aktualisiere(Turnier turnier) {
        Spieler aktiver = turnier.aktiver();
        int rest = aktiver.rest();
        boolean fertig = rest == 0;
        this.nachricht.setText(String.valueOf(aktiver.anzeigename()) + " ist an der Reihe!");
        this.nachricht.setFont(new Font("Dialog", 1, 12));
        if (fertig) {
            this.restanzeige.setText("Bitte in der Tabelle setzen!");
        } else {
            this.restanzeige.setText(String.valueOf(rest) + " mal darf noch gew\u00fcrfelt werden.");
        }
    }

    private void baue() {
        JPanel verfolgungsfeld = new JPanel(new BorderLayout());
        verfolgungsfeld.add((Component)this.verfolgung, "Center");
        JPanel zeilenfeld = new JPanel(new BorderLayout());
        JPanel zeilen = new JPanel();
        zeilen.setLayout(new BoxLayout(zeilen, 3));
        zeilen.add(Box.createVerticalGlue());
        zeilen.add(this.nachricht);
        zeilen.add(Box.createVerticalStrut(4));
        zeilen.add(this.restanzeige);
        zeilen.add(Box.createVerticalGlue());
        zeilenfeld.add((Component)zeilen, "Center");
        this.setLayout(new BoxLayout(this, 3));
        this.add(Box.createVerticalStrut(8));
        this.add(verfolgungsfeld);
        this.add(Box.createVerticalStrut(4));
        this.add(zeilenfeld);
    }

    private void beendeSpiel() {
        this.nachricht.setText("Dieses Spiel ist beendet.");
        this.restanzeige.setText("Gleich geht es weiter...");
    }

    private void beendeTurnier(String status) {
        this.nachricht.setText(status);
        this.nachricht.setFont(new Font("Dialog", 3, 12));
        this.restanzeige.setText("Auf Wiedersehen...");
    }

    private void dekoriere(Wuerfelfeld.Kontextmenue kontextmenue) {
        this.nachricht.setAlignmentX(0.5f);
        this.restanzeige.setAlignmentX(0.5f);
    }
}

