/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.bedienung;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.Range;
import com.orsoncharts.axis.NumberAxis3D;
import com.orsoncharts.axis.StandardCategoryAxis3D;
import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.graphics3d.Offset2D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.interaction.Chart3DMouseEvent;
import com.orsoncharts.interaction.Chart3DMouseListener;
import com.orsoncharts.label.CategoryItemLabelGenerator;
import com.orsoncharts.label.StandardCategoryItemLabelGenerator;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.BarRenderer3D;
import com.orsoncharts.renderer.category.CategoryColorSource;
import com.orsoncharts.renderer.category.StandardCategoryColorSource;
import com.orsoncharts.table.RectanglePainter;
import com.orsoncharts.table.StandardRectanglePainter;
import jafuffy.bedienung.Hinweissteuerung;
import jafuffy.bedienung.Report;
import jafuffy.logik.Spieler;
import jafuffy.logik.Statistik;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseListener;
import javax.swing.JPanel;

class Verlaufsgrafik
extends JPanel {
    private static final int BREITE = 600;
    private static final int HOEHE = 360;
    private static final double ZLAENGE = 0.7;
    private static final double XLAENGE = 0.5;
    private static final Range WERTEBEREICH = new Range(0.0, 350.0);
    private static final double DREHWINKEL = -0.20943951023931953;
    private static final double ROLLWINKEL = 0.13962634015954636;
    private static final double RHO = 55.0;
    private static final Offset2D VERSCHIEBUNG = new Offset2D(0.0, -20.0);
    private static final int PROJEKTIONSDISTANZ = 1000;
    private static final BasicStroke GITTERLINIENSTIL = new BasicStroke(0.25f);
    private static final Color WANDFARBE = new Color(176, 192, 192, 64);
    private static final Color ZAHLSCHRIFTFARBE = Color.GRAY;
    private static final Color ACHSSCHRIFTFARBE = Color.LIGHT_GRAY;
    private static final Font ZAHLSCHRIFTART = new Font("SansSerif", 0, 11);
    private static final Font ACHSSCHRIFTART = new Font("SansSerif", 1, 11);
    private static final double RANDABSTAND = 0.17;
    private static final int P = 250;
    private static final int N = 5;
    private static final int S = 3;
    private final Chart3D chart = Verlaufsgrafik.chart();
    private final CategoryPlot3D plot = (CategoryPlot3D)this.chart.getPlot();
    private final Chart3DPanel panel;
    private final DisplayPanel3D display;
    private StandardCategoryDataset3D<String, Integer, Integer> datensatz;

    private static Chart3D chart() {
        Chart3D chart = Chart3DFactory.createBarChart(null, null, Verlaufsgrafik.platzhalter(), null, (String)"Spielnummer", (String)"Punktzahl");
        chart.setAntiAlias(true);
        chart.setLegendBuilder(null);
        chart.setChartBoxColor(WANDFARBE);
        chart.setProjDistance(1000.0);
        chart.setViewPoint(Verlaufsgrafik.perspektive());
        chart.setBackground((RectanglePainter)new StandardRectanglePainter((Paint)Report.HINTERGRUNDFARBE));
        chart.setTranslate2D(VERSCHIEBUNG);
        return chart;
    }

    private static StandardCategoryDataset3D<String, Integer, Integer> datensatz(Statistik statistik) {
        StandardCategoryDataset3D datensatz = new StandardCategoryDataset3D();
        for (Spieler spieler : statistik.teilnehmer()) {
            DefaultKeyedValues reihe = new DefaultKeyedValues();
            int i = 0;
            while (i < statistik.spielanzahl()) {
                reihe.put((Comparable)Integer.valueOf(i + 1), (Object)statistik.verlaeufe().get(spieler.index()).get(i));
                ++i;
            }
            i = statistik.spielanzahl();
            while (i < statistik.maximalanzahl()) {
                reihe.put((Comparable)Integer.valueOf(i + 1), (Object)0);
                ++i;
            }
            datensatz.addSeriesAsRow((Comparable)((Object)spieler.anzeigename()), (Comparable)Integer.valueOf(spieler.index()), (KeyedValues)reihe);
        }
        return datensatz;
    }

    private static void konfiguriere(CategoryPlot3D plot) {
        plot.getRowAxis().setVisible(false);
        plot.setGridlineStrokeForValues((Stroke)GITTERLINIENSTIL);
        plot.setToolTipGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("<html><strong>%1$s</strong> hat im %3$d. Spiel <strong>%4$.0f Punkte</strong> erzielt.</html>"));
        StandardCategoryAxis3D turnierachse = (StandardCategoryAxis3D)plot.getColumnAxis();
        turnierachse.setLabelFont(ACHSSCHRIFTART);
        turnierachse.setLabelColor(ACHSSCHRIFTFARBE);
        turnierachse.setTickLabelFont(ZAHLSCHRIFTART);
        turnierachse.setTickLabelColor(ZAHLSCHRIFTFARBE);
        NumberAxis3D punktzahlachse = (NumberAxis3D)plot.getValueAxis();
        punktzahlachse.setLabelFont(ACHSSCHRIFTART);
        punktzahlachse.setLabelColor(ACHSSCHRIFTFARBE);
        punktzahlachse.setTickLabelFont(ZAHLSCHRIFTART);
        punktzahlachse.setTickLabelColor(ZAHLSCHRIFTFARBE);
        punktzahlachse.setAutoRangeIncludeZero(true);
        punktzahlachse.setAutoRangeStickyZero(true);
        punktzahlachse.setRange(WERTEBEREICH);
        BarRenderer3D renderer = (BarRenderer3D)plot.getRenderer();
        renderer.setColors(Report.BALKENFARBEN);
        renderer.setTopColorSource((CategoryColorSource)new StandardCategoryColorSource(new Color[]{Color.YELLOW}));
        renderer.setBarXWidth(0.5);
        renderer.setBarZWidth(0.7);
    }

    private static Chart3DPanel panel(final Chart3D chart) {
        final Chart3DPanel panel = new Chart3DPanel(chart);
        panel.setMargin(0.17);
        panel.zoomToFit();
        panel.addMouseListener((MouseListener)new Hinweissteuerung());
        panel.addChartMouseListener(new Chart3DMouseListener(){

            public void chartMouseClicked(Chart3DMouseEvent event) {
                if (event.getTrigger().getClickCount() > 1) {
                    chart.setViewPoint(Verlaufsgrafik.perspektive());
                    chart.setTranslate2D(VERSCHIEBUNG);
                    panel.zoomToFit();
                }
            }

            public void chartMouseMoved(Chart3DMouseEvent event) {
            }
        });
        return panel;
    }

    private static ViewPoint3D perspektive() {
        ViewPoint3D perspektive = ViewPoint3D.createAboveRightViewPoint((double)55.0);
        perspektive.panLeftRight(-0.20943951023931953);
        perspektive.roll(0.13962634015954636);
        return perspektive;
    }

    private static StandardCategoryDataset3D<String, Integer, Integer> platzhalter() {
        StandardCategoryDataset3D platzhalter = new StandardCategoryDataset3D();
        int s = 1;
        while (s <= 3) {
            DefaultKeyedValues reihe = new DefaultKeyedValues();
            int n = 1;
            while (n <= 5) {
                reihe.put((Comparable)Integer.valueOf(n), (Object)250);
                ++n;
            }
            platzhalter.addSeriesAsRow((Comparable)((Object)("Name " + s + " (Spieler " + s + ")")), (Comparable)Integer.valueOf(s), (KeyedValues)reihe);
            ++s;
        }
        return platzhalter;
    }

    Verlaufsgrafik() {
        super(new BorderLayout());
        Verlaufsgrafik.konfiguriere(this.plot);
        this.panel = Verlaufsgrafik.panel(this.chart);
        this.panel.setPreferredSize(new Dimension(600, 360));
        this.display = new DisplayPanel3D((Panel3D)this.panel);
        this.add((Component)this.display);
    }

    void aktualisiere(Statistik statistik) {
        for (Spieler spieler : statistik.teilnehmer()) {
            int punktzahl = statistik.verlaeufe().get(spieler.index()).get(statistik.spielanzahl() - 1);
            this.datensatz.setValue((Number)punktzahl, (Comparable)((Object)spieler.anzeigename()), (Comparable)Integer.valueOf(spieler.index()), (Comparable)Integer.valueOf(statistik.spielanzahl()));
        }
    }

    void beende(Statistik statistik) {
        if (statistik.rest() > 0) {
            for (Spieler spieler : statistik.teilnehmer()) {
                this.datensatz.setValue((Number)0, (Comparable)((Object)spieler.anzeigename()), (Comparable)Integer.valueOf(spieler.index()), (Comparable)Integer.valueOf(statistik.spielanzahl()));
            }
        }
    }

    void starte(Statistik statistik) {
        this.datensatz = Verlaufsgrafik.datensatz(statistik);
        this.plot.setDataset(this.datensatz);
        this.revalidate();
        this.panel.zoomToFit();
    }
}

