/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik;

import jafuffy.logik.ereignis.Aenderungen;
import jafuffy.logik.ereignis.Wuerfelstand;
import jafuffy.netzwerk.Vermittlung;
import java.io.Serializable;
import java.util.Random;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;

public class Wuerfel
extends Aenderungen<Wuerfelstand>
implements Vermittlung.Wurf,
Comparable<Wuerfel>,
Serializable {
    private static final long serialVersionUID = 6889772262239748227L;
    public static final int MAXIMALAUGENAUGENZAHL = 6;
    private static final Random ZUFALL = new Random();
    private transient ButtonModel darstellungsmodell;
    private int augen;
    private boolean vorgeschlagen;

    Wuerfel(int augen) {
        this.augen = augen;
    }

    public int augen() {
        return this.augen;
    }

    @Override
    public int compareTo(Wuerfel wuerfel) {
        return Integer.compare(this.augen(), wuerfel.augen());
    }

    public ButtonModel darstellungsmodell() {
        if (this.darstellungsmodell == null) {
            this.darstellungsmodell = new JToggleButton.ToggleButtonModel(){

                @Override
                public void setSelected(boolean selektiert) {
                    boolean feuern = this.isSelected() ^ selektiert;
                    super.setSelected(selektiert);
                    if (feuern) {
                        Wuerfel.this.fireStateChanged(selektiert ? Wuerfelstand.ANWAHL : Wuerfelstand.ABWAHL);
                    }
                }
            };
        }
        return this.darstellungsmodell;
    }

    public void setzeVorschlag(boolean vorschlagen) {
        this.vorgeschlagen = vorschlagen;
    }

    @Override
    public void uebertrage(int augen) {
        this.augen = augen;
        this.vorgeschlagen = false;
        this.fireStateChanged(Wuerfelstand.WURF);
        this.darstellungsmodell.setSelected(false);
    }

    public boolean vorgeschlagen() {
        return this.vorgeschlagen;
    }

    public int vorkommen(int[] haeufigkeiten) {
        return haeufigkeiten[this.augen - 1];
    }

    @Override
    public void waehle(boolean selektiert) {
        this.darstellungsmodell.setSelected(selektiert);
    }

    void wirf() {
        this.augen = ZUFALL.nextInt(6) + 1;
        this.uebertrage(this.augen);
    }
}

