/*
 * Decompiled with CFR 0.152.
 */
package jafuffy.logik.analyse;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

class Strasse {
    Strasse() {
    }

    protected static enum Index {
        EINSER,
        ZWEIER,
        DREIER,
        VIERER,
        FUENFER,
        SECHSER;


        public static boolean istKleineStrasse(int[] augenhaeufigkeiten) {
            return augenhaeufigkeiten[DREIER.ordinal()] > 0 && augenhaeufigkeiten[VIERER.ordinal()] > 0 && (augenhaeufigkeiten[EINSER.ordinal()] > 0 && augenhaeufigkeiten[ZWEIER.ordinal()] > 0 || augenhaeufigkeiten[ZWEIER.ordinal()] > 0 && augenhaeufigkeiten[FUENFER.ordinal()] > 0 || augenhaeufigkeiten[FUENFER.ordinal()] > 0 && augenhaeufigkeiten[SECHSER.ordinal()] > 0);
        }

        public static boolean istGrosseStrasse(int[] augenhaeufigkeiten) {
            return augenhaeufigkeiten[ZWEIER.ordinal()] == 1 && augenhaeufigkeiten[DREIER.ordinal()] == 1 && augenhaeufigkeiten[VIERER.ordinal()] == 1 && augenhaeufigkeiten[FUENFER.ordinal()] == 1 && (augenhaeufigkeiten[EINSER.ordinal()] == 1 || augenhaeufigkeiten[SECHSER.ordinal()] == 1);
        }

        public int augen() {
            return this.ordinal() + 1;
        }
    }

    static class KleinerIndex
    implements Serializable {
        private static final long serialVersionUID = -6498075827504305923L;
        static final Map<KleinerIndex, Float> TABELLE = new HashMap<KleinerIndex, Float>();
        private final int aussen;
        private final int innen;
        private final int mitte;
        private final int rest;

        static {
            KleinerIndex.tabelliere(0, 0, 1, 1, 0.212963f);
            KleinerIndex.tabelliere(0, 0, 1, 2, 0.489169f);
            KleinerIndex.tabelliere(0, 0, 2, 1, 0.3611111f);
            KleinerIndex.tabelliere(0, 0, 2, 2, 0.6584362f);
            KleinerIndex.tabelliere(0, 1, 0, 1, 0.1481481f);
            KleinerIndex.tabelliere(0, 1, 0, 2, 0.3912751f);
            KleinerIndex.tabelliere(0, 1, 1, 1, 0.25f);
            KleinerIndex.tabelliere(0, 1, 1, 2, 0.5150463f);
            KleinerIndex.tabelliere(0, 1, 2, 1, 0.5555556f);
            KleinerIndex.tabelliere(0, 1, 2, 2, 0.8024691f);
            KleinerIndex.tabelliere(0, 2, 0, 1, 0.1388889f);
            KleinerIndex.tabelliere(0, 2, 0, 2, 0.3526235f);
            KleinerIndex.tabelliere(0, 2, 1, 1, 0.3055556f);
            KleinerIndex.tabelliere(0, 2, 1, 2, 0.5177469f);
            KleinerIndex.tabelliere(1, 0, 0, 1, 0.1018519f);
            KleinerIndex.tabelliere(1, 0, 0, 2, 0.3410851f);
            KleinerIndex.tabelliere(1, 0, 1, 1, 0.1666667f);
            KleinerIndex.tabelliere(1, 0, 1, 2, 0.4293981f);
            KleinerIndex.tabelliere(1, 0, 2, 1, 0.3611111f);
            KleinerIndex.tabelliere(1, 0, 2, 2, 0.6296296f);
            KleinerIndex.tabelliere(1, 1, 0, 1, 0.1388889f);
            KleinerIndex.tabelliere(1, 1, 0, 2, 0.3526235f);
            KleinerIndex.tabelliere(1, 1, 1, 1, 0.3055556f);
            KleinerIndex.tabelliere(1, 1, 1, 2, 0.5177469f);
        }

        private static void tabelliere(int aussen, int innen, int mitte, int rest, float p) {
            TABELLE.put(new KleinerIndex(aussen, innen, mitte, rest), Float.valueOf(p));
        }

        KleinerIndex(int aussen, int innen, int mitte, int rest) {
            this.aussen = aussen;
            this.innen = innen;
            this.mitte = mitte;
            this.rest = rest;
        }

        public boolean equals(Object obj) {
            KleinerIndex index = (KleinerIndex)obj;
            return this.aussen == index.aussen && this.innen == index.innen && this.mitte == index.mitte && this.rest == index.rest;
        }

        public int hashCode() {
            return 3 * (3 * (3 * this.aussen + this.innen) + this.mitte) + this.rest;
        }
    }

    static enum Paar {
        LINKS(Index.EINSER, Index.ZWEIER),
        INNEN(Index.ZWEIER, Index.FUENFER),
        RECHTS(Index.FUENFER, Index.SECHSER),
        MITTE(Index.DREIER, Index.VIERER);

        private final Index[] feld = new Index[2];

        private Paar(Index paar0, Index paar1) {
            this.feld[0] = paar0;
            this.feld[1] = paar1;
        }

        final Index[] feld() {
            return this.feld;
        }

        int vorkommen(int[] augenhaeufigkeiten) {
            int gefunden = 0;
            Index[] indexArray = this.feld;
            int n = this.feld.length;
            int n2 = 0;
            while (n2 < n) {
                Index element = indexArray[n2];
                if (augenhaeufigkeiten[element.ordinal()] > 0) {
                    ++gefunden;
                }
                ++n2;
            }
            return gefunden;
        }
    }
}

