/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts;

import com.orsoncharts.TitleAnchor;
import com.orsoncharts.interaction.InteractiveElementType;
import com.orsoncharts.table.GridElement;
import com.orsoncharts.table.HAlign;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.table.TextElement;
import com.orsoncharts.util.Anchor2D;
import java.awt.Color;
import java.awt.Font;

public class TitleUtils {
    public static final Font DEFAULT_TITLE_FONT = new Font("Dialog", 1, 20);
    public static final Color DEFAULT_TITLE_COLOR = Color.BLACK;
    public static final Font DEFAULT_SUBTITLE_FONT = new Font("Dialog", 0, 12);

    private TitleUtils() {
    }

    public static TableElement createTitle(String title) {
        return TitleUtils.createTitle(title, null);
    }

    public static TableElement createTitle(String title, String subtitle) {
        return TitleUtils.createTitle(title, subtitle, TitleAnchor.TOP_LEFT);
    }

    public static TableElement createTitle(String title, String subtitle, Anchor2D anchor) {
        HAlign alignment = HAlign.LEFT;
        if (anchor.getRefPt().isHorizontalCenter()) {
            alignment = HAlign.CENTER;
        } else if (anchor.getRefPt().isRight()) {
            alignment = HAlign.RIGHT;
        }
        return TitleUtils.createTitle(title, DEFAULT_TITLE_FONT, subtitle, DEFAULT_SUBTITLE_FONT, alignment);
    }

    public static TableElement createTitle(String title, Font titleFont, String subtitle, Font subtitleFont, HAlign alignment) {
        TextElement t = new TextElement(title, titleFont);
        t.setHorizontalAligment(alignment);
        t.setColor(DEFAULT_TITLE_COLOR);
        t.setTag("CHART_TITLE");
        t.setProperty("class", (Object)InteractiveElementType.TITLE);
        if (subtitle == null) {
            return t;
        }
        if (subtitleFont == null) {
            throw new IllegalArgumentException("A subtitleFont is required when there is a subtitle.");
        }
        GridElement<String, String> compositeTitle = new GridElement<String, String>();
        TextElement st = new TextElement(subtitle, subtitleFont);
        st.setHorizontalAligment(alignment);
        st.setColor(DEFAULT_TITLE_COLOR);
        st.setTag("CHART_SUBTITLE");
        st.setProperty("class", (Object)InteractiveElementType.SUBTITLE);
        compositeTitle.setElement(t, "R1", "C1");
        compositeTitle.setElement(st, "R2", "C1");
        return compositeTitle;
    }
}

