/******************************************************************************
 ** $Id: Vertreter.java 2551 2021-01-06 15:34:22Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik;

import jafuffy.Eigenschaften;

/** Vertreter fr das Agieren eines Mitspielers an einem anderen Austragungsort bei Turnierbetrieb ber ein Netzwerk. */
public class Vertreter extends Spieler {

    /** Zur Serialisierung. */
    private static final long serialVersionUID = 4845084184796235443L;

    /**
     * Legt einen Spieler an, welcher als Vertreter an einem Turnier ber ein Netzwerk teilnehmen kann.
     *
     * @param name
     *            Name des Vertreters.
     * @param eigenschaften
     *            Die von diesem Vertreter verwendeten allgemeinen Eigenschaften.
     */
    public Vertreter(Name name, Eigenschaften eigenschaften) {
        super(name, eigenschaften);
    }

    @Override
    public boolean stellvertretend() {
        return true;
    }
}
