/******************************************************************************
 ** $Id: Umschlag.java 2541 2021-01-04 01:38:30Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ** Lauffhig ab Java 7.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 2 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.logik.ereignis;

import javax.swing.event.ChangeEvent;

/** Umschlag als Behlter fr ein nderungsereignis. */
public class Umschlag<E, Q> extends ChangeEvent {

    private static final long serialVersionUID = 3157912329618967872L;

    /** Detaillierung des auslsenden Ereignisses . */
    private final E ereignis;

    /**
     * @return Gibt an, ob Quelle vom Typ her gleich dieser Klasse ist.
     */
    public static boolean adressiert(ChangeEvent ce, Class<?> klasse) {
        return (((Umschlag<?, ?>) ce).ereignis().getClass() == klasse);
    }

    /**
     * Konstruktor.
     *
     * @param quelle
     *            Auslser.
     * @param ereignis
     *            Detaillierung des Ereignisses.
     */
    Umschlag(Q quelle, E ereignis) {
        super(quelle);
        this.ereignis = ereignis;
    }

    /**
     * @param klasse
     *            Diese Ereignisklasse soll adressiert sein.
     * @return Gibt an, ob das Ereignis zur angegebenen Klasse gehrt.
     */
    boolean addressiert(Class<?> klasse) {
        return ereignis.getClass() == klasse;
    }

    /** @return Gespeichertes Ereignis. */
    public E ereignis() {
        return ereignis;
    }

    /** Liefert die Quelle des nderungsereignisses. */
    @SuppressWarnings("unchecked")
    public Q quelle() {
        return (Q) getSource();
    }

    @SuppressWarnings("unchecked")
    /** Konversion macht aus einem ChangeEvent einen Umschlag. */
    public static <E, Q> Umschlag<E, Q> ereignisbehaelter(ChangeEvent ce) {
        return (Umschlag<E, Q>) ce;
    }

}
