/******************************************************************************
 ** $Id: Bestaetigung.java 2514 2020-09-13 19:21:59Z wmh $
 ** Diese Datei ist Bestandteil der Java-Quelltexte des Wrfelspiels JaFuffy.
 ******************************************************************************
 ** Copyright (C) Wolfgang Hauck <wolfgang.hauck@3kelvin.de>
 ******************************************************************************
 ** This program is free software: you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, either version 3 of the License, or
 ** (at your option) any later version.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ******************************************************************************
 ** Die aktuellste Version von JaFuffy findet sich im Internet unter
 ** <http://jafuffy.3kelvin.de>.
 **
 ** Kommentare, Fehler oder Erweiterungswnsche bitte per E-Mail senden an
 ** <jafuffy@3kelvin.de>.
 ******************************************************************************/
package jafuffy.netzwerk;

import java.io.Serializable;
import java.util.ArrayList;

/** Besttigungsnachricht zwecks Anmeldung zum Turnier bers Netzwerk. */
class Bestaetigung implements Serializable {

    private static final long serialVersionUID = -4837677403418279305L;

    /** Kontaktdaten des Absenders dieser Nachricht. */
    private final Kontakt kontakt;
    /** Die Liste aller hier bekannten angemeldeten Teilnehmer. */
    private final ArrayList<String> anmeldungen;

    /**
     * Erstellt eine Besttigungsnachricht.
     *
     * @param kontakt
     *            Kontaktdaten des Absenders.
     * @param anmeldungen
     *            Die Liste aller hier bekannten angemeldeten Teilnehmer.
     */
    Bestaetigung(Kontakt kontakt, ArrayList<String> anmeldungen) {
        this.kontakt = kontakt;
        this.anmeldungen = anmeldungen;
    }

    /** Liefert Absenderadresse. */
    Kontakt kontakt() {
        return kontakt;
    }

    /** Liefert die Liste aller hier bekannten angemeldeten Teilnehmer.. */
    ArrayList<String> anmeldungen() {
        return anmeldungen;
    }

}